<?php

class CreateTableMissions extends Doctrine_Migration_Base
{
    private $_tableName = 'missions';
    
    function up()
    {
        $this->createTable($this->_tableName, array(
            'id' => array(
                'type' => 'integer',
                'primary' => true,
                'autoincrement' => true,
            ),
            'map_id' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'goal_cash' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'goal_regions' => array(
                'type' => 'character varying(256)',
                'notnull' => false,
            ),
            'goal_map_regions_count' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'goal_map_regions_percent' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'goal_factory_level_id' => array(
                'type' => 'integer',
                'notnull' => true,
            ),
            'goal_limit_rounds' => array(
                'type' => 'integer',
                'notnull' => true,
            ),
            'active' => array(
                'type' => 'smallint',
                'notnull' => false,
            ),
        ));
    }

    public function postUp()
    {
        Doctrine_Manager::connection()->exec('ALTER TABLE ' . $this->_tableName . ' ALTER COLUMN active SET DEFAULT 1');
    }

    public function down()
    {
        $this->dropTable($this->_tableName);
    }
}

?>
