<?php

class CreateTableMaps extends Doctrine_Migration_Base
{
    private $_tableName = 'maps';
    
    function up()
    {
        $this->createTable($this->_tableName, array(
            'id' => array(
                'type' => 'integer',
                'primary' => true,
                'autoincrement' => true,
            ),
            'bitmap' => array(
                'type' => 'character varying(256)',
                'notnull' => false,
            ),
            'width' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'height' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'fields_h' => array(
                'type' => 'integer',
                'notnull' => false,
			),
            'fields_v' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'fields' => array(
                'type' => 'text',
                'notnull' => false,
            ),			
            'height' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'active' => array(
                'type' => 'smallint',
                'notnull' => false,
            ),
        ));
    }

    public function postUp()
    {
        Doctrine_Manager::connection()->exec('ALTER TABLE ' . $this->_tableName . ' ALTER COLUMN fields_h SET DEFAULT 1');
        Doctrine_Manager::connection()->exec('ALTER TABLE ' . $this->_tableName . ' ALTER COLUMN fields_v SET DEFAULT 1');
        Doctrine_Manager::connection()->exec('ALTER TABLE ' . $this->_tableName . ' ALTER COLUMN active SET DEFAULT 1');
    }

    public function down()
    {
        $this->dropTable($this->_tableName);
    }
}

?>
