<?php

class CreateTableGameMaps extends Doctrine_Migration_Base
{
    private $_tableName = 'game_maps';
    
    function up()
    {
        $this->createTable($this->_tableName, array(
            'id' => array(
                'type' => 'integer',
                'primary' => true,
                'autoincrement' => true,
            ),
            'game_id' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'fields_economy' => array(
                'type' => 'text',
                'notnull' => false,
            ),
            'fields_population' => array(
                'type' => 'text',
                'notnull' => false,
            ),
            'fields_shops' => array(
                'type' => 'text',
                'notnull' => false,
            ),
            'fields_staff' => array(
                'type' => 'text',
                'notnull' => false,
            ),
            'active' => array(
                'type' => 'smallint',
                'notnull' => false,
            ),
        ));
    }

    public function postUp()
    {
        Doctrine_Manager::connection()->exec('ALTER TABLE ' . $this->_tableName . ' ALTER COLUMN active SET DEFAULT 1');
    }

    public function down()
    {
        $this->dropTable($this->_tableName);
    }
}

?>
