<?php

class CreateTableProduct extends Doctrine_Migration_Base
{
    private $_tableName = 'products';
    
    function up()
    {
        $this->createTable($this->_tableName, array(
            'id' => array(
                'type' => 'integer',
                'primary' => true,
                'autoincrement' => true,
            ),
            'cost' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'profit' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'weight' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'factory_level_id' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'shop_level_id' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'active' => array(
                'type' => 'smallint',
                'notnull' => false,
            ),
        ));
    }

    public function postUp()
    {
        Doctrine_Manager::connection()->exec('ALTER TABLE ' . $this->_tableName . ' ALTER COLUMN active SET DEFAULT 1');
    }

    public function down()
    {
        $this->dropTable($this->_tableName);
    }
}

?>
