<?php

class Model_BankRow extends Zend_Db_Table_Row_Abstract
{

    public function saveTranslations($lang_ids, $names, $descriptions)
    {
        $mBankLang = new Model_BankLang;
        foreach ($lang_ids as $key => $lang_id) {
            $translate = $mBankLang->getByBankId($this->id, $lang_id);
            $data = array(
                'bank_id' => $this->id,
                'lang_id' => $lang_id,
                'name' => $names[$key],
                'description' => $descriptions[$key]
            );
            if (isset($translate->id)) {
                $where = $mBankLang->getAdapter()->quoteInto('id = ?', $translate->id);
                $mBankLang->update($data, $where);
            } else {
                $mBankLang->insert($data);
            }
        }
    }

    public function loadTranslations()
    {
        $mBankLang = new Model_BankLang;

        return $mBankLang->getByBankId($this->id);
    }

    public function getTranslation($lang_id = false)
    {
        $mBankLang = new Model_BankLang;

        return $mBankLang->getByBankId($this->id, $lang_id);
    }

    public function name($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->name;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->name;
            }
        }

        return $translation;
    }

    public function description($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->description;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->description;
            }
        }

        return $translation;
    }

    public function deleteTranslations()
    {
        $mBankLang = new Model_BankLang;
        $where = $mBankLang->getAdapter()->quoteInto('bank_id = ?', $this->id);
        $mBankLang->delete($where);
    }

}
