<?php

class Model_DeliveryLang extends Zend_Db_Table_Abstract
{
    protected $_name = 'deliveries_lang';

    public function getById($id)
    {
        $query = $this->select();
        $query->where('id = ?', $id);

        return $this->fetchRow($query);
    }

    public function getByDeliveryId($delivery_id, $lang_id = false)
    {
        $query = $this->select();
        $query->where('delivery_id = ?', $delivery_id);
        if ($lang_id) {
            $query->where('lang_id = ?', $lang_id);

            return $this->fetchRow($query);
        } else {
            return $this->fetchAll($query);
        }
    }

    public function getAll()
    {
        $query = $this->select();

        return $this->fetchAll($query);
    }

    public function getTranslations($delivery_id)
    {
        $query = $this->select();
        $query->where('delivery_id = ?', $delivery_id);

        return $this->fetchAll($query);
    }

}

