<?php

class Model_Event extends Zend_Db_Table_Abstract
{
    protected $_name = 'events';
    protected $_rowClass = 'Model_EventRow';

    public function getById($id, $lang_id = 1)
    {
        $eventModel = new self();

        return $eventModel->fetchRow(array('id = ?' => $id));
    }

    public function getAll($lang_id = 1)
    {
        $languageTable = new Model_TaxLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('e' => 'events'), array('e.*'));
        $query->join(array('l' => 'events_lang'), 'e.id = l.event_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        $query->where('l.lang_id = ?', $lang_id);

        return $this->fetchAll($query);
    }

    public function getAllActiveNotIn($items = false, $lang_id = 1)
    {
        $languageTable = new Model_TaxLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('e' => 'events'), array('e.*'));
        $query->join(array('l' => 'events_lang'), 'e.id = l.event_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        if ($items) $query->where('e.id NOT IN(?)', $items);
        $query->where('e.active = ?', 1);
        $query->where('l.lang_id = ?', $lang_id);

        return $this->fetchAll($query);
    }

    function events($params, $lang_id = 1)
    {
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }
        if (!isset($params['page'])) {
            $params['page'] = 1;
        }
        $languageTable = new Model_EventLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('e' => 'events'), array('e.*'));
        $query->join(array('l' => 'events_lang'), 'e.id = l.event_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        // TODO: dokończyć implementacje obslugi wielu języków
        $query->where('l.lang_id = ?', $lang_id);
        if (isset($params['sort'])) {
            switch ($params['sort']) {
                case 'cash':
                    $query->order('cash');
                    break;
                case 'percent':
                    $query->order('percent');
                    break;
                case 'active':
                    $query->order('active');
                    break;
                case 'id':
                default:
                    $query->order('id');
                    break;
            }
        } else {
            $query->order('id');
        }

        $paginator = new Zend_Paginator(new Zend_Paginator_Adapter_DbTableSelect($query));

        $paginator->setItemCountPerPage($params['perPage']);
        $paginator->setCurrentPageNumber($params['page']);

        return $paginator;
    }

    public function _parseEventsParams($params)
    {
        // Domyślnie chcemy wyświetlać po 5 rekordów na stronę
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }

        // Filtrujemy puste wartości
        foreach ($params as $key => $value) {
            if (is_null($value) or $value == '') {
                unset($params[$key]);
                continue;
            }
            switch ($key) {
                case 'module':
                case 'controller':
                case 'action':
                case 'submit':
                    // Te dane nie będą nam potrzebne - usuwamy
                    unset($params[$key]);
                    continue;
                    break;
            }
        }

        return $params;
    }

}

