<?php

class Model_EventLang extends Zend_Db_Table_Abstract
{
    protected $_name = 'events_lang';

    public function getById($id)
    {
        $query = $this->select();
        $query->where('id = ?', $id);

        return $this->fetchRow($query);
    }

    public function getByEventId($event_id, $lang_id = false)
    {
        $query = $this->select();
        $query->where('event_id = ?', $event_id);
        if ($lang_id) {
            $query->where('lang_id = ?', $lang_id);

            return $this->fetchRow($query);
        } else {
            return $this->fetchAll($query);
        }
    }

    public function getAll()
    {
        $query = $this->select();

        return $this->fetchAll($query);
    }

    public function getTranslations($event_id)
    {
        $query = $this->select();
        $query->where('event_id = ?', $event_id);

        return $this->fetchAll($query);
    }

}

