<?php

class Model_FactoryLevel extends Zend_Db_Table_Abstract
{
    protected $_name = 'factory_levels';
    protected $_rowClass = 'Model_FactoryLevelRow';

    public function getById($id, $lang_id = 1)
    {
        $factory_levelModel = new self();

        return $factory_levelModel->fetchRow(array('id = ?' => $id));
    }

    public function getAll($lang_id = 1)
    {
        $languageTable = new Model_TaxLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('f' => 'factory_levels'), array('f.*'));
        $query->join(array('l' => 'factory_levels_lang'), 'f.id = l.factory_level_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        $query->where('l.lang_id = ?', $lang_id);

        return $this->fetchAll($query, 'f.id ASC');
    }

    /**
     * @param int $lang_id
     * @return Zend_Db_Table_Rowset_Abstract|Model_FactoryLevelRow[]
     */
    public function getAllActive($lang_id = 1)
    {
        $languageTable = new Model_TaxLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('f' => 'factory_levels'), array('f.*'));
        $query->join(array('l' => 'factory_levels_lang'), 'f.id = l.factory_level_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        $query->where('f.active = ?', 1);
        $query->where('l.lang_id = ?', $lang_id);
        $query->order('f.id ASC');
        return $this->fetchAll($query);
    }

    function factory_levels($params, $lang_id = 1)
    {
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }
        if (!isset($params['page'])) {
            $params['page'] = 1;
        }
        $languageTable = new Model_FactoryLevelLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('f' => 'factory_levels'), array('f.*'));
        $query->join(array('l' => 'factory_levels_lang'), 'f.id = l.factory_level_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        // TODO: dokończyć implementacje obslugi wielu języków
        $query->where('l.lang_id = ?', $lang_id);
        if (isset($params['sort'])) {
            switch ($params['sort']) {
                case 'cost':
                    $query->order('goal_cash');
                    break;
                case 'production':
                    $query->order('percent');
                    break;
                case 'active':
                    $query->order('active');
                    break;
                case 'id':
                default:
                    $query->order('id');
                    break;
            }
        } else {
            $query->order('id');
        }

        $paginator = new Zend_Paginator(new Zend_Paginator_Adapter_DbTableSelect($query));

        $paginator->setItemCountPerPage($params['perPage']);
        $paginator->setCurrentPageNumber($params['page']);

        return $paginator;
    }

    public function _parseFactoryLevelsParams($params)
    {
        // Domyślnie chcemy wyświetlać po 5 rekordów na stronę
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }

        // Filtrujemy puste wartości
        foreach ($params as $key => $value) {
            if (is_null($value) or $value == '') {
                unset($params[$key]);
                continue;
            }
            switch ($key) {
                case 'module':
                case 'controller':
                case 'action':
                case 'submit':
                    // Te dane nie będą nam potrzebne - usuwamy
                    unset($params[$key]);
                    continue;
                    break;
            }
        }

        return $params;
    }

}

