<?php

class Model_GameMapRow extends Zend_Db_Table_Row_Abstract
{
    public function init()
    {
        if ($this->fields_economy)
            $this->fields_economy = json_decode($this->fields_economy);

        if ($this->fields_population)
            $this->fields_population = json_decode($this->fields_population);

        if ($this->fields_shops)
            $this->fields_shops = json_decode($this->fields_shops);

        if ($this->fields_staff)
            $this->fields_staff = json_decode($this->fields_staff);

        parent::init();
    }

    public function save()
    {
        $pop = array();
        foreach ($this->fields_population as $r => $row) {
            foreach ($row as $c => $p) {
                $pop[] = $p;
            }
        }

        sort($pop);
        reset($pop);

//        $p_min = current($pop);;
//        $p_max = end($pop);
//        $p_3   = round(($p_max - $p_min) / 3);
//
//        $bad     = $p_min;
//        $medium  = $p_min + $p_3;
//        $good    = $p_min + $p_3 + $p_3;

        $c = count($pop);

        $bad    = round($c / 3);
        $medium = $bad * 2;

        $economy = array();

        foreach ($this->fields_population as $r => $row) {
            foreach ($row as $c => $p) {
                if ($p <= $pop[$bad])
                    $economy[$r][$c] = 1;
                elseif ($p <= $pop[$medium])
                    $economy[$r][$c] = 2;
                else
                    $economy[$r][$c] = 3;
            }
        }

        $this->fields_economy = json_encode($economy);
        $this->fields_population = json_encode($this->fields_population);
        $this->fields_shops = json_encode($this->fields_shops);
        $this->fields_staff = json_encode($this->fields_staff);

        return parent::save();
    }

    /**
     * @return array
     */
    public function getFieldsEconomy()
    {
        return $this->fields_economy;
    }

    /**
     * @return array
     */
    public function getFieldsPopulation()
    {
        return $this->fields_population;
    }

    /**
     * @return array
     */
    public function getFieldsShops()
    {
        return $this->fields_shops;
    }

    /**
     * @return array
     */
    public function getFieldsStaff()
    {
        return $this->fields_staff;
    }

}
