<?php

class Model_GameRow extends Zend_Db_Table_Row_Abstract
{
    /**
     * @var Model_GameMapRow
     */
    protected $_gameMap;

    /**
     * @var Model_MissionRow
     */
    protected $_gameMission;

    public function init()
    {
        if ($this->game_data)
            $this->game_data = json_decode($this->game_data);

        parent::init();
    }

    public function save()
    {
        if ($this->game_data)
            $this->game_data = json_encode($this->game_data);

        return parent::save();
    }

    /**
     * @return Model_GameMapRow
     */
    public function getGameMap()
    {
        if ($this->_gameMap == null) {
            $modelGameMap = new Model_GameMap;
            $this->_gameMap = $modelGameMap->getByGameId($this->id);
        }
        return $this->_gameMap;
    }

    /**
     * @return array
     */
    public function getGameData()
    {
        return $this->game_data;
    }

    // Popraw wielkości produkcji - zmienna potrzebna do szybkiewgo wyświetlenia w interfejsie
    public function updateProduction($factory_id)
    {
        $mFactoryProduct = new Model_FactoryProduct;
        $production = $mFactoryProduct->byFactoryId($factory_id)->toArray();
        $this->game_data->production = $production;
    }

    // Wirtualny przeciwnik - kolo na ślepo stawia sklepy, od czasu do czasu i zajmuje pola graczowi
    public function opponentMove($ratio = 10)
    {
        $opponent = null;
        if ($ratio > 0 && rand(0, 100) <= $ratio) {
            $gameMap = $this->getGameMap();
            while ($opponent == null) {
                $fields_shops = $gameMap->fields_shops;
                $max_y = count($fields_shops);
                $max_x = count($fields_shops[0]);
                $x = rand(0, ($max_x - 1));
                $y = rand(0, ($max_y - 1));
                if ($fields_shops[$y][$x] == 0 || ($fields_shops[$y][$x] >= 500 && $fields_shops[$y][$x] < 599)) {
                    if ($fields_shops[$y][$x] >= 500 && $fields_shops[$y][$x] < 599) {
                        $fields_shops[$y][$x] = $fields_shops[$y][$x] + 1;
                    } else {
                        $fields_shops[$y][$x] = 500;
                    }
                    $opponent = array(
                        'x' => $x,
                        'y' => $y,
                        'value' => $fields_shops[$y][$x]
                    );
                    if (isset($this->game_data->history->opponent)) {
                        $this->game_data->history->opponent = json_decode(json_encode($this->game_data->history->opponent), true);
                    } else {
                        $this->game_data->history->opponent = array();
                    }
                    $this->game_data->history->opponent[$this->round] = $opponent;
                    $gameMap->fields_shops = $fields_shops;
                    $gameMap->save();
                }
            }
        }

        return $opponent;
    }

    public function isGameOver($bankrupt = 0)
    {
        $game_over = array(
            'mission_complete' => 0,
            'mission_complete_round' => 0,
            'mission_complete_cash' => 0,
            'mission_complete_factory' => 0,
            'mission_complete_regions' => 0,
            'mission_objectives' => 0,
            'bankrupt' => 0
        );
        // 1. Sprawdź czy gracz nie powinien zbankrutować
        if ($this->cash >= 0) {
            $this->game_data->bankrupt_counter = 0;
        }
        if ($bankrupt > 0) {
            if ($this->cash < 0) {
                $this->game_data->bankrupt_counter++;
                if ($this->game_data->bankrupt_counter >= $bankrupt) {
                    $game_over['bankrupt'] = 1;
                    $this->active = 0;
                }
            }
        }
        // 2. Sprawdź czy nie osiągnął celu misji
        $mission = $this->getMission();
        $gameData = $this->getGameData();
        if (isset($mission->id)) {
            // 2.1. Sprawdż czy gracz osiągnął limit rund
            if ($mission->goal_limit_rounds > 0 && $mission->goal_limit_rounds <= $this->round) {
                $game_over['mission_complete'] = 1;
                $game_over['mission_complete_round'] = 1;
            }
            // 2.2. Sprawdż czy kwota docelowa zostało osiągnięta
            if ($mission->goal_cash > 0 && $mission->goal_cash <= $this->cash) {
                $game_over['mission_complete'] = 1;
                $game_over['mission_objectives'] = 1;
                $game_over['mission_complete_cash'] = 1;
            }
            // 2.3. Sprawdż czy gracz osiągnął wymagany poziom fabryki
            if ($mission->goal_factory_level_id > 0 && $mission->goal_factory_level_id <= $gameData->factory) {
                $game_over['mission_complete'] = 1;
                $game_over['mission_objectives'] = 1;
                $game_over['mission_complete_factory'] = 1;
            }
            // 2.4. Sprawdż czy gracz zbudował wystarczającą ilość sklepów
            if ($mission->goal_map_regions_count > 0 && $mission->goal_map_regions_count <= $this->getShopsCount()) {
                $game_over['mission_complete'] = 1;
                $game_over['mission_objectives'] = 1;
                $game_over['mission_complete_regions'] = 1;
            }
            // 2.5. Gra typu "graj X rund", oznacz, że wykonana aby komunikat był poprawny
            if ($mission->goal_limit_rounds > 0 && $mission->goal_limit_rounds <= $this->round && $mission->goal_cash == 0 && $mission->goal_factory_level_id == 0 && $mission->goal_map_regions_count == 0) {
                $game_over['mission_objectives'] = 1;
            }
        }
        if ($game_over['bankrupt'] == 1 || $game_over['mission_complete'] == 1 || $game_over['mission_objectives'] == 1) {
            $this->active = 0;
            $this->finished = date('Y-m-d H:i:s');
            if ($game_over['bankrupt'] == 1) {
                $this->bankrupt = 1;
            }
            if ($game_over['mission_complete'] == 1) {
                $this->mission_complete = 1;
            }
            if ($game_over['mission_objectives'] == 1) {
                $this->mission_objectives = 1;
            }
        }

        return $game_over;
    }

    // Wylosuj zdarzenie losowe :-)
    public function getEvent($ratio = 10)
    {
        $event = null;

        $mission = $this->getMission();
        // jeśli misja ma X rund i zostało mniej niz 1 runda do końca, to nie wywalaj zdarzeń
        if ($mission->goal_limit_rounds > 0 && ($mission->goal_limit_rounds - $this->round) <= 1)
            return $event;

        // 1. Pierwszy krok - zdecyduj czy wylosować zdarzenie, czy nie
        if ($ratio > 0 && rand(0, 100) <= $ratio) {
            // 1.1 Sprawdź czy dane zdarzenie losowe nie wystapiło wcześniej
            $history_events = array();
            if (isset($this->game_data->history->events) && count($this->game_data->history->events) > 0) {
                foreach ($this->game_data->history->events as $e) {
                    if (isset($e->allow_once) && $e->allow_once == 1) {
                        $history_events[] = $e->event_id;
                    }
                }
            }
            $mEvent = new Model_Event;
            $allEvents = $mEvent->getAllActiveNotIn($history_events);
            if (count($allEvents) > 0) {
                // 2. Kolejny krok: wylosuj zdarzenie losowe
                $event = $allEvents[array_rand($allEvents->toArray())];
                if (isset($event->id)) {
                    // wartość kary (bez znaku)
                    $event_cash = abs($event->cash);
                    // max(% z obecnej kasy, minimalna kara)
                    if ($event->percent) {
                        $event_cash = max($this->cash * $event->percent / 100, $event_cash);
                    }
                    if ($event->cash < 0) {
                        // jeśli to mandat, nie zabieraj więcej niż połowę tego co teraz mam
                        $event_cash = -1 * min($event_cash, $this->cash / 2);
                    }

                    $this->game_data->history->events = json_decode(json_encode($this->game_data->history->events), true);
                    $this->game_data->history->events[$this->round] = array(
                        'event_id' => $event->id,
                        'allow_once' => $event->allow_once,
                        'event_cash' => $event_cash
                    );

                    $this->cash += $event_cash;
                    $this->save();

                    $event = $event->toArray();
                    $event['event_cash'] = abs($event_cash);
                    $event['description'] = sprintf($event['description'], $event['event_cash']);
                } else {
                    $event = null;
                }
            }
        }

        return $event;
    }

    /**
     * @return array
     */
    public function getPopulation()
    {
        return $this->getGameMap()->getFieldsPopulation();
    }

    /**
     * @return array
     */
    public function getBuildings()
    {
        return $this->getGameMap()->getFieldsShops();
    }

    /**
     * @return array
     */
    public function getEconomy()
    {
        return $this->getGameMap()->getFieldsEconomy();
    }

    public function getFields()
    {
        // wygeneruj tablice z kolorkami pól mapy
        // 3 kolorki w zależności od wielkości populacji
        $fields = array();
        $population = $this->getGameMap()->getFieldsPopulation();
        $buildings = $this->getGameMap()->getFieldsShops();
        $pop = array();
        foreach($population as $y) {
            foreach($y as $x) {
                if($x > 0) {
                    $pop[] = $x;
                }
            }
        }
        $pop = array_unique($pop);
        sort($pop);
        $p_min = $pop[0];
        $p_max = end($pop);
        // $p_med = (int) round(($p_max - $p_min)/2) + $p_min;
        $p_3 = (int) round(($p_max - $p_min)/3);
        $l = $p_min;
        $m = $p_min+$p_3;
        $h = $p_min+$p_3+$p_3;
        // foreach($population as )
        foreach($this->getGameMap()->fields_economy as $y=>$row) {
            foreach($row as $x=>$field) {
                $f = $field;
                if($field < 100 && isset($population[$y][$x])) {
                    if($population[$y][$x] >= $l) {
                        $f = 1;
                    }
                    if($population[$y][$x] > $m) {
                        $f = 2;
                    }
                    if($population[$y][$x] > $h) {
                        $f = 3;
                    }
                } elseif (isset($buildings[$y][$x])) {
                    $f = $buildings[$y][$x];
                }
                $fields[$y][$x] = $f;
            }
        }
        return $fields;
    }

    /**
     * @return array
     */
    public function calculateNextRound()
    {
        $PRODUCTION   = $this->getFactoryProduction();
        $MAX_CAPACITY = $this->getDeliveryCapacity();
        $MAX_SALE     = $this->getMaxSale();
        $TO_SALE      = min($PRODUCTION, $MAX_CAPACITY, $MAX_SALE);

        $SOLD = 0;
        $INCOME = 0;
        $LOG = array();

        if ($TO_SALE > 0) {
            $P = $TO_SALE / $MAX_SALE;
            $modelShop = new Model_Shop;
            $allShops = $modelShop->getAllActive();
            foreach ($this->getGameMap()->getFieldsShops() as $r => $row) {
                foreach ($row as $c => $shopLevel) {
                    if ($shopLevel > 0 && $shopLevel < 100 && $allShops->offsetExists($shopLevel)) {
                        $shop = $allShops->offsetGet($shopLevel);
                        foreach ($shop->getProducts() as $product) {
                            $sale = max(min(ceil($product->sale * $P), $TO_SALE - $SOLD), 0);
                            $LOG["$r:$c:$product->name"] = array(
                                $product->sale, $shop->getSale(), $P, $sale
                            );
                            $SOLD += $sale;
                            $INCOME += ($sale * $product->profit);
                        }
                    }
                }
            }
        }

        $FACTORY_COST = $this->getFactoryStaffCost();
        $DELIVERY_COST = $this->getDeliveryCost();
        $SHOPS_COST = $this->getShopsStaffCost();

        $COSTS = $FACTORY_COST + $DELIVERY_COST + $SHOPS_COST;

        $PROFIT = $INCOME - $COSTS;

        return compact('PRODUCTION', 'MAX_CAPACITY', 'MAX_SALE', 'TO_SALE', 'SOLD', 'INCOME', 'FACTORY_COST', 'DELIVERY_COST', 'SHOPS_COST', 'COSTS', 'PROFIT', 'LOG');
    }

    /**
     * @param float $p1
     * @param float $p2
     */
    public function calculatePopulation($p1, $p2)
    {
        $map = $this->getGameMap();
        $population = array();
        foreach ($map->getFieldsPopulation() as $r => $row) {
            foreach ($row as $c => $pop) {
                $delta = ceil($pop / $p1 + pow($this->round, $p2));
                if (rand(0, 100) < 30)
                    $delta *= (-1);

                $population[$r][$c] = $pop + $delta;
            }
        }
        $map->fields_population = $population;
        $map->save();
    }

    /**
     * @return array
     */
    public function nextRound()
    {
        $data = $this->calculateNextRound();

        $this->game_data->production = (array) $this->game_data->production;
        $this->game_data->delivery = (array) $this->game_data->delivery;
        $this->game_data->sale = (array) $this->game_data->sale;
        $this->game_data->history->production = (array) $this->game_data->history->production;
        $this->game_data->history->sale = (array) $this->game_data->history->sale;
        $this->game_data->history->delivery = (array) $this->game_data->history->delivery;
        $this->game_data->history->bookkeeping = (array) $this->game_data->history->bookkeeping;

        $this->game_data->history->production[$this->round] = $data['PRODUCTION'];
        $this->game_data->history->sale[$this->round] = $data['MAX_SALE'];
        $this->game_data->history->delivery[$this->round] = $data['MAX_CAPACITY'];
        $this->game_data->history->bookkeeping[$this->round] = array(
            'income' => $data['INCOME'],
            'costs'  => $data['COSTS']
        );
        $this->cash += $data['PROFIT'];
        $this->profit = $data['PROFIT'];
        $this->round++;

        $app = Zend_Registry::get('app');
        // Ruch przeciwnika (w parametrze współczynnik częstotliwości zapisany w application.ini/local.ini)
        $opponent = $this->opponentMove($app['opponent_ratio']);
        // Wylosuj zdarzenie losowe (w parametrze współczynnik częstotliwości zapisany w application.ini/local.ini)
        $event = $this->getEvent($app['events_ratio']);
        // Sprawdź czy nie zbankrutować (jezeli parametr == 0, opcja wyłączona)	i czy nie osiągnięto celu misji
        $game_over = $this->isGameOver($app['bankrupt']);
        //Zaktualizuj populacje
        $this->calculatePopulation($app['population_param1'], $app['population_param2']);

        $this->save();

        return compact('opponent', 'event', 'game_over');
    }

    /**
     * @return int
     */
    public function getFactoryProduction()
    {
        $modelFactory = new Model_FactoryLevel;
        $allFactories = $modelFactory->getAllActive();

        $factory = $allFactories[$this->game_data->factory];

        return $factory->getProduction();
    }

    /**
     * @return int
     */
    public function getDeliveryCapacity()
    {
        $modelDelivery = new Model_Delivery;
        $capacity = 0;
        foreach ($modelDelivery->getAllActive() as $k => $delivery) {
            if (isset($this->game_data->delivery[$k]))
                $quantity = $this->game_data->delivery[$k]->quantity;
            else
                $quantity = 0;

            $capacity += ($quantity * $delivery->capacity);
        }

        return $capacity;
    }

    /**
     * @return int
     */
    public function getMaxSale()
    {
        $modelShop = new Model_Shop;
        $allShops = $modelShop->getAllActive();
        $map = $this->getGameMap();
        $population = $map->getFieldsPopulation();
        $sale = 0;
        foreach ($this->getGameMap()->getFieldsShops() as $r => $row) {
            foreach ($row as $c => $shopLevel) {
                if ($shopLevel > 0 && $shopLevel < 100 && $allShops->offsetExists($shopLevel)) {
                    $shop = $allShops->offsetGet($shopLevel);
                    $sale += min($shop->getSale(), $population[$r][$c]);
                }
            }
        }

        return $sale;
    }

    /**
     * @return int
     */
    public function getActualSale()
    {
        $data = $this->calculateNextRound();
        return $data['TO_SALE'];
    }

    /**
     * @return int
     */
    public function getFactoryStaffCost()
    {
        $modelFactory = new Model_FactoryLevel;
        $allFactories = $modelFactory->getAllActive();

        $factory = $allFactories[$this->game_data->factory];

        return $factory->getStaffCost();
    }

    /**
     * @return int
     */
    public function getDeliveryCost()
    {
        $modelDelivery = new Model_Delivery;
        $cost = 0;
        foreach ($modelDelivery->getAllActive() as $k => $delivery) {
            if (isset($this->game_data->delivery[$k]))
                $quantity = $this->game_data->delivery[$k]->quantity;
            else
                $quantity = 0;

            $cost += ($quantity * $delivery->cost);
        }

        return $cost;
    }

    /**
     * @return int
     */
    public function getShopsStaffCost()
    {
        $modelShop = new Model_Shop;
        $allShops = $modelShop->getAllActive();
        $cost = 0;
        foreach ($this->getGameMap()->getFieldsShops() as $r => $row) {
            foreach ($row as $c => $shopLevel) {
                if ($shopLevel > 0 && $shopLevel < 100 && $allShops->offsetExists($shopLevel)) {
                    $shop = $allShops->offsetGet($shopLevel);
                    $cost += $shop->getStaffCost();
                }
            }
        }

        return $cost;
    }

    /**
     * @return int
     */
    public function getShopsCount()
    {
        $count = 0;
        foreach ($this->getGameMap()->getFieldsShops() as $r => $row)
            foreach ($row as $c => $field)
                if ($field > 0 && $field < 100)
                    $count++;

        return $count;
    }

    /**
     * @return Model_MissionRow
     */
    public function getMission()
    {
        if ($this->_gameMission == null) {
            $modelMission = new Model_Mission;
            $this->_gameMission = $modelMission->find($this->mission_id)->current();
        }
        return $this->_gameMission;
    }
}
