<?php

class Model_MissionLang extends Zend_Db_Table_Abstract
{
    protected $_name = 'missions_lang';

    public function getById($id)
    {
        $query = $this->select();
        $query->where('id = ?', $id);

        return $this->fetchRow($query);
    }

    public function getByMissionId($mission_id, $lang_id = false)
    {
        $query = $this->select();
        $query->where('mission_id = ?', $mission_id);
        if ($lang_id) {
            $query->where('lang_id = ?', $lang_id);

            return $this->fetchRow($query);
        } else {
            return $this->fetchAll($query);
        }
    }

    public function getAll()
    {
        $query = $this->select();

        return $this->fetchAll($query);
    }

    public function getTranslations($mission_id)
    {
        $query = $this->select();
        $query->where('mission_id = ?', $mission_id);

        return $this->fetchAll($query);
    }

}

