<?php

class Model_ProductLang extends Zend_Db_Table_Abstract
{
    protected $_name = 'products_lang';

    public function getById($id)
    {
        $query = $this->select();
        $query->where('id = ?', $id);

        return $this->fetchRow($query);
    }

    public function getByProductId($product_id, $lang_id = false)
    {
        $query = $this->select();
        $query->where('product_id = ?', $product_id);
        if ($lang_id) {
            $query->where('lang_id = ?', $lang_id);

            return $this->fetchRow($query);
        } else {
            return $this->fetchAll($query);
        }
    }

    public function getAll()
    {
        $query = $this->select();

        return $this->fetchAll($query);
    }

    public function getTranslations($product_id)
    {
        $query = $this->select();
        $query->where('product_id = ?', $product_id);

        return $this->fetchAll($query);
    }

}

