<?php

class Model_ProductRow extends Zend_Db_Table_Row_Abstract
{

    public function saveTranslations($lang_ids, $names, $descriptions)
    {
        $mProductLang = new Model_ProductLang;
        foreach ($lang_ids as $key => $lang_id) {
            $translate = $mProductLang->getByProductId($this->id, $lang_id);
            $data = array(
                'product_id' => $this->id,
                'lang_id' => $lang_id,
                'name' => $names[$key],
                'description' => $descriptions[$key]
            );
            if (isset($translate->id)) {
                $where = $mProductLang->getAdapter()->quoteInto('id = ?', $translate->id);
                $mProductLang->update($data, $where);
            } else {
                $mProductLang->insert($data);
            }
        }
    }

    public function loadTranslations()
    {
        $mProductLang = new Model_ProductLang;

        return $mProductLang->getByProductId($this->id);
    }

    public function getTranslation($lang_id = false)
    {
        $mProductLang = new Model_ProductLang;

        return $mProductLang->getByProductId($this->id, $lang_id);
    }

    public function name($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->name;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->name;
            }
        }

        return $translation;
    }

    public function description($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->description;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->description;
            }
        }

        return $translation;
    }

    public function deleteTranslations()
    {
        $mProductLang = new Model_ProductLang;
        $where = $mProductLang->getAdapter()->quoteInto('product_id = ?', $this->id);
        $mProductLang->delete($where);
    }

}
