<?php

class Model_ShopLang extends Zend_Db_Table_Abstract
{
    protected $_name = 'shops_lang';

    public function getById($id)
    {
        $query = $this->select();
        $query->where('id = ?', $id);

        return $this->fetchRow($query);
    }

    public function getByShopId($shop_id, $lang_id = false)
    {
        $query = $this->select();
        $query->where('shop_id = ?', $shop_id);
        if ($lang_id) {
            $query->where('lang_id = ?', $lang_id);

            return $this->fetchRow($query);
        } else {
            return $this->fetchAll($query);
        }
    }

    public function getAll()
    {
        $query = $this->select();

        return $this->fetchAll($query);
    }

    public function getTranslations($shop_id)
    {
        $query = $this->select();
        $query->where('shop_id = ?', $shop_id);

        return $this->fetchAll($query);
    }

}

