<?php

class Model_TaxLang extends Zend_Db_Table_Abstract
{
    protected $_name = 'taxes_lang';

    public function getById($id)
    {
        $query = $this->select();
        $query->where('id = ?', $id);

        return $this->fetchRow($query);
    }

    public function getByTaxId($tax_id, $lang_id = false)
    {
        $query = $this->select();
        $query->where('tax_id = ?', $tax_id);
        if ($lang_id) {
            $query->where('lang_id = ?', $lang_id);

            return $this->fetchRow($query);
        } else {
            return $this->fetchAll($query);
        }
    }

    public function getAll()
    {
        $query = $this->select();

        return $this->fetchAll($query);
    }

    public function getTranslations($tax_id)
    {
        $query = $this->select();
        $query->where('tax_id = ?', $tax_id);

        return $this->fetchAll($query);
    }

}

