<?php

class Model_TaxRow extends Zend_Db_Table_Row_Abstract
{

    public function saveTranslations($lang_ids, $names, $descriptions)
    {
        $mTaxLang = new Model_TaxLang;
        foreach ($lang_ids as $key => $lang_id) {
            $translate = $mTaxLang->getByTaxId($this->id, $lang_id);
            $data = array(
                'tax_id' => $this->id,
                'lang_id' => $lang_id,
                'name' => $names[$key],
                'description' => $descriptions[$key]
            );
            if (isset($translate->id)) {
                $where = $mTaxLang->getAdapter()->quoteInto('id = ?', $translate->id);
                $mTaxLang->update($data, $where);
            } else {
                $mTaxLang->insert($data);
            }
        }
    }

    public function loadTranslations()
    {
        $mTaxLang = new Model_TaxLang;

        return $mTaxLang->getByTaxId($this->id);
    }

    public function getTranslation($lang_id = false)
    {
        $mTaxLang = new Model_TaxLang;

        return $mTaxLang->getByTaxId($this->id, $lang_id);
    }

    public function name($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->name;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->name;
            }
        }

        return $translation;
    }

    public function description($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->description;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->description;
            }
        }

        return $translation;
    }

    public function deleteTranslations()
    {
        $mTaxLang = new Model_TaxLang;
        $where = $mTaxLang->getAdapter()->quoteInto('tax_id = ?', $this->id);
        $mTaxLang->delete($where);
    }

}
