<?php

class Zend_View_Helper_EditForm extends Zend_View_Helper_Abstract
{

    public function EditForm($fields = false, $action = array(), $menu = false)
    {
        if ($fields) {
            $action_string = '';
            foreach ($action as $a) {
                $action_string .= '/' . $a;
            }
            echo '<form id="EditForm" method="post" action="' . $this->view->baseUrl($action_string) . '">' . "\n";
            echo '<dl>' . "\n";
            $required_definition = false;
            $language_id = true;
            foreach ($fields as $field) {
                if (!isset($field['type'])) {
                    $field['type'] = 'text';
                }
                if (isset($field['name']) && $field['type'] != 'hidden') {
                    $cl = 'input_' . $field['name'];
                    if (!isset($field['value'])) {
                        $field['value'] = '';
                    }
                    // 1. Tytuł pola:
                    if (isset($field['languages']) && count($field['languages']) > 0) {
                        echo '<div style="clear:both;overflow:hidden;">';
                    }
                    if (isset($field['title'])) {
                        echo '<dt>' . $field['title'];
                        if (isset($field['required']) && $field['required'] == 'true' || isset($field['required']) && $field['required'] == true) {
                            $cl .= ' validate[required';
                            if (isset($field['validation']) && $field['validation'] != '') {
                                $cl .= ',custom[' . $field['validation'] . ']';
                            }
                            $cl .= ']';
                            echo '<span class="required">*</span>';
                            $required_definition = true;
                        } else {
                            if (isset($field['validation']) && $field['validation'] != '') {
                                $cl .= ' validate[custom[' . $field['validation'] . ']]';
                            }
                        }
                    }
                    echo ' :</dt>' . "\n";
                    // 2. Pola formularza:
                    // 2.1. Pole typu "select"
                    if ($field['type'] == 'select' && is_array($field['options'])) {
                        echo '<dd>';
                        echo '<select id="" name="' . $field['name'] . '" class="' . $cl . '" >';
                        foreach ($field['options'] as $i => $option) {
                            if ($i > 0 && $field['value'] == $option[0]) {
                                echo '<option value="' . $option[0] . '" selected="selected">' . $option[1] . '</option>';
                            } else {
                                echo '<option value="' . $option[0] . '">' . $option[1] . '</option>';
                            }
                        }
                        echo '</select>';
                        echo '</dd>' . "\n";
                        // 2.2. Inne rodzaje pól
                    } else {
                        echo '<dd>';
                        if (isset($field['languages']) && count($field['languages']) > 0) {
                            // 2.2.1 Z tłumaczeniami
                            foreach ($field['languages'] as $lang) {
                                echo '<h5>' . $lang->name . ' :</h5>';
                                // a) dodaj inputa z id języka
                                if ($language_id) echo '<input type="hidden" name="language_id[]" value="' . $lang->id . '" />';
                                // b) wstaw aktualne tłumaczenie o ile istnieje
                                if (isset($field['value'][$lang->id])) {
                                    $value = $field['value'][$lang->id];
                                } else {
                                    $value = '';
                                }
                                // c) wyświetl pole formularza
                                if ($field['type'] == 'textarea') {
                                    echo '<textarea name="' . $field['name'] . '[]" class="' . $cl . '" />' . $value . '</textarea>';
                                } else {
                                    echo '<input type="' . $field['type'] . '" name="' . $field['name'] . '[]" value="' . $value . '" class="' . $cl . '" />';
                                }
                            }
                            $language_id = false;
                            echo '</dd></div>' . "\n";
                        } else {
                            // 2.2.2 Bez tłumaczeniami
                            if ($field['type'] == 'textarea') {
                                echo '<textarea name="' . $field['name'] . '" class="' . $cl . '" />' . $field['value'] . '</textarea>';
                            } else {
                                echo '<input type="' . $field['type'] . '" name="' . $field['name'] . '" value="' . $field['value'] . '" class="' . $cl . '" />';
                            }
                            echo '</dd>' . "\n";
                        }
                    }
                } elseif ($field['type'] == 'hidden') {
                    echo '<input type="' . $field['type'] . '" name="' . $field['name'] . '" value="' . $field['value'] . '" />';
                }
            }
            echo '</dl>' . "\n";
            if ($required_definition) {
                echo '<p class="form_legend"><span class="required">*</span> - ' . $this->view->translate('Pole wymagane') . '</p>' . "\n";
                echo '<script>
					$(document).ready(function() {
						$("#EditForm").validationEngine(\'attach\',{
							\'autoHidePrompt\': true
						});
					});
					</script>' . "\n";
            }
            if ($menu) {
                $this->view->Menu($menu);
            }
            echo '</form>' . "\n";
        }
    }

}
