<?php

class Zend_View_Helper_Map extends Zend_View_Helper_Abstract
{
    public function Map(Model_GameRow $game, Model_MapRow $map, $id = 'Map')
    {
        $top_menu = array();
        $top_menu[] = array(
            'class' => 'analytics',
            'text' => $this->view->translate('Analiza'),
        );
        $top_menu[] = array(
            'class' => 'objectives',
            'text' => $this->view->translate('Szczegóły misji'),
        );
        $top_menu[] = array(
            'class' => 'user_guide',
            'text' => $this->view->translate('Podręcznik gracza'),
        );
        $top_menu[] = array(
            'class' => 'ranking',
            'text' => $this->view->translate('Ranking'),
        );
        $top_menu[] = array(
            'class' => 'quit',
            'text' => $this->view->translate('Koniec gry'),
        );


        $top_bar = array(
            array(
                'class' => 'round',
                'value' => $game->round,
                'suffix' => '',
                'prefix' => '',
                'original_title' => $this->view->translate('Pozostały czas do końca tury. Kliknij, aby przyspieszyć.'),
            ),
            array(
                'class' => 'sale',
                'value' => 0,
                'suffix' => '',
                'prefix' => '',
                'original_title' => $this->view->translate('Aktualna sprzedaż / potencjalna maksymalna sprzedaż'),
            ),
            array(
                'class' => 'delivery',
                'value' => 0,
                'suffix' => '',
                'prefix' => '',
                'original_title' => $this->view->translate('Możliwość dystrybucji'),
            ),
            array(
                'class' => 'factory',
                'value' => 0,
                'suffix' => '',
                'prefix' => '',
                'original_title' => $this->view->translate('Wielkość produkcji'),
            ),
            array(
                'class' => 'cash',
                'value' => $game->cash,
                'suffix' => ' ' . $this->view->app['currency'],
                'prefix' => '',
                'original_title' => $this->view->translate('Stan konta'),
            ),
        );

        $options = array(
            'cols' => $map->fields_h,
            'rows' => $map->fields_v,
            'duration' => $this->view->app['round_duration'] * 1000,
            'baseUrl' => $this->view->baseUrl('/'),
            'round' => $game->round,
            'strings' => array(
                'ARE_YOU_SURE' => $this->view->translate('Czy jesteś pewien?'),
                'QUIT' => $this->view->translate('Na pewno chcesz zakończyć grę? Zostanie ona usunięta.'),
                'CLOSE' => $this->view->translate('Zamknij okno'),
                'SHOP' => $this->view->translate('Sklep'),
                'NEW_SHOP' => $this->view->translate('Zbuduj sklep'),
                'POPULATION' => $this->view->translate('Potencjał sprzedaży'),
                'POPULATION_IS' => $this->view->translate('Aktualnie w tej dzielnicy potencjał sprzedaży wynosi'),
                'TOOLTIP_NEW_SHOP' => $this->view->translate('sztuk. Kliknij tutaj aby zbudować sklep w tym miejscu.'),
                'TOOLTIP_FACTORY' => $this->view->translate('Kliknij tutaj by zarządzać piekarnią.'),
                'TOOLTIP_SHOP' => $this->view->translate('Kliknij tutaj by zarządzać sklepem.'),
                'TOOLTIP_DELIVERY' => $this->view->translate('Dealer samochodowy.'),
                'TOOLTIP_OPPONENT' => $this->view->translate('Na tym obszarze znajduje się już piekarnia konkurencji. Ne możesz tutaj postawić swojego sklepu.'),
                'CURRENCY' => $this->view->app['currency'],
                'YOU_EARN' => $this->view->translate('Zyskujesz'),
                'YOU_LOSE' => $this->view->translate('Tracisz'),
                'BANKRUPT' => $this->view->translate('Koniec gry. Zbankrutowałeś.'),
                'MISSION_COMPLETE' => $this->view->translate('Koniec gry. Cel misji nie został osiągnięty.'),
                'MISSION_OBJECTIVES' => $this->view->translate('Koniec gry. Misja zakończona pomyślnie!.'),
                'NO_CASH' => $this->view->translate('Nie stać Cię na to.'),
            )
        );
        $optionsJS = json_encode($options);

        echo '<div class="bar top_bar">';
        echo '<ul class="top_bar_elements">';
        echo '<li class="top_bar_menu tooltip" original-title="' . $this->view->translate('Menu główne') . '"><a href="javascript:void(null)"></a></li>';
        echo '<li class="top_bar_fields tooltip menu_off" original-title="' . $this->view->translate('Podświetl mapę') . '"></li>';

        foreach ($top_bar as $v)
            echo $this->topBarElement($v['class'], $v['value'], $v['suffix'], $v['prefix'], $v['original_title']);
        echo '<li class="top_bar_player_name">' . $game->player_name . '</li>';
        echo '</ul>';
        echo '<ul class="top_bar_menu">';
        foreach ($top_menu as $v)
            echo $this->topBarMenu($v['class'], $v['text']);
        echo '</ul>';
        echo '</div>';
        echo '<div id="' . $id . '" class="map">';
        echo '<img src="' . $this->view->baseUrl('/maps/' . $map->bitmap) . '" alt="' . $map->name(1) . '" />';
        echo '</div>';
        echo '<script src="' . $this->view->baseUrl('/js/map.js?' . date('YmdHis')) . '" type="text/javascript"></script>';
        echo '<script type="text/javascript">
    $(window).load(function(){
        $("#' . $id . '").drawMap(' . $optionsJS . ');
    });
    </script>';
        echo '<style type="text/css">
    body {
        background-image: none;
    }
    </style>';
    }

    /**
     * @param string $class
     * @param $value
     * @param $suffix
     * @param $prefix
     * @param string $original_title
     * @return string
     */
    protected function topBarElement($class = '', $value, $suffix, $prefix, $original_title = '')
    {
        if ($class != '')
            $class = ' top_bar_' . $class;

        return sprintf('<li class="top_bar_element%s tooltip" original-title="%s"><span class="top_bar_icon"></span><div class="top_bar_container"><span class="top_bar_value">%s%s%s</span></div></li>', $class, $original_title, $prefix, $value, $suffix);
    }

    /**
     * @param $class
     * @param $text
     * @return string
     */
    protected function topBarMenu($class, $text)
    {
        return sprintf('<li class="%s"><span>&nbsp;</span>%s</li>', $class, $text);
    }
}
