<?php
/**
 * @author Radosław Szczepaniak <radoslaw.szczepaniak@gammanet.pl>
 */

class Zend_View_Helper_PaginatorSort extends Zend_View_Helper_Abstract
{
    /**
     * @param string $label
     * @param string $name
     * @param string $sortBy
     * @param string $sortDir
     * @return string
     */
    public function paginatorSort($label, $name, $sortBy, $sortDir)
    {
        $sortDir = strtolower($sortDir);
        if ($name == $sortBy)
            if ($sortDir == 'asc')
                $sortDir = 'desc';
            else
                $sortDir = 'asc';
        else
            $sortDir = 'asc';

        $url = $this->view->url(array('sort_by' => $name, 'sort_dir' => $sortDir));

        if ($name == $sortBy)
            return sprintf('<a class="sort sort_%s" href="%s">%s</a>', $sortDir, $url, $label);

        return sprintf('<a class="sort" href="%s">%s</a>', $url, $label);
    }
}