<?php

/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Zend
 * @package    Zend_Gdata
 * @subpackage App
 * @copyright  Copyright (c) 2005-2011 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @version    $Id: Author.php 23775 2011-03-01 17:25:24Z ralph $
 */

/**
 * Represents the docs:writersCanInvite	 element
 *
 * @category   Zend
 * @package    Zend_Gdata
 * @subpackage App
 * @copyright  Copyright (c) 2005-2011 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */
class Zend_Gdata_Docs_WritersCanInvite extends Zend_Gdata_App_Base
{

    protected $_value;
    protected $_entryClassName = 'Zend_Gdata_Docs_WritersCanInvite';
    protected $_rootNamespace = 'docs';
    protected $_rootElement = 'writersCanInvite';

    public function __construct($value=null)
    {
        $this->registerNamespace('docs', 'http://schemas.google.com/docs/2007');
        if ($value !== null) {
            $this->setValue($value);
        }
        parent::__construct();
    }

    public function getDOM($doc = null, $majorVersion = 1, $minorVersion = null)
    {
        $element = parent::getDOM($doc, $majorVersion, $minorVersion);
        if ($this->_value !== null) {
            $element->setAttribute('value', $this->_value);
        }
        return $element;
    }

    protected function takeAttributeFromDOM($attribute)
    {
        switch ($attribute->localName) {
            case 'value':
                $this->_value = $attribute->nodeValue;
                break;
            default:
                parent::takeAttributeFromDOM($attribute);
        }
    }

    public function setValue($value)
    {
		$this->_value = $value != 0 ? 'true' : 'false';
        return $this;
    }

    public function getValue()
    {
        return $this->_value;
    }
}

