<?php
/**
 * @author Radosław Szczepaniak <radoslaw.szczepaniak@gammanet.pl>
 */

$tables = array(
    'deliveries',
    'deliveries_lang',
    'events',
    'events_lang',
    'factory_levels',
    'factory_levels_lang',
    'factory_products',
    'languages',
    'maps',
    'maps_lang',
    'missions',
    'missions_lang',
    'products',
    'products_lang',
    'shop_products',
    'shops',
    'shops_lang',
    'user_roles',
);

define('APPLICATION_PATH', realpath(dirname(__FILE__) . '/../application'));
define('APPLICATION_ENV', 'development');

set_include_path(implode(PATH_SEPARATOR, array(
    realpath(APPLICATION_PATH . '/../library'),
    get_include_path(),
)));

require_once 'Zend/Application.php';

$application = new Zend_Application(
    APPLICATION_ENV,
    APPLICATION_PATH . '/configs/application.ini'
);
$application->bootstrap();

foreach ($tables as $tableName) {
    $tmp  = "<?php return array(\n";
    $tmp .= "\tarray(";
    $model = new Zend_Db_Table($tableName);
    $columns = $model->info(Zend_Db_Table::COLS);
    array_shift($columns);
    foreach ($columns as $v) {
        $tmp .= "'$v', ";
    }
    $tmp .= "),\n";
    foreach ($model->fetchAll(null, 'id ASC') as $v) {
        $tmp .= "\tarray(";
        $data = $v->toArray();
        array_shift($data);
        foreach ($data as $d) {
            if (is_numeric($d)) {
                $tmp .= "$d, ";
            } else {
                $tmp .= "'$d', ";
            }
        }
        $tmp .= "),\n";
    }
    $tmp .= ");";
    file_put_contents(APPLICATION_PATH . '/migrations/fixtures/' . $tableName . '.php', $tmp);
}