
$(function()
	{
	/**
	 * jPlayer
	 */
	$('#jplayer').on($.jPlayer.event.ready,function()
		{
		$('#jplayer').jPlayer('setMedia', {mp3: './media/file2.mp3'});
		});

	/**
	 * Elements
	 */
	var elements = [];
	for(var i=1;i<=25;++i)
		{
		elements[i-1] = i;
		if (i === 7 || i === 10) elements[i-1] = 17;
		}

	$.each(_.shuffle(elements),function(index,value)
		{
		$('.elements').append('<img src="./styles/images/('+value+').png" alt=""/>');
		});

	/**
	 * Rotate elements
	 */
	for(var i=1;i<=25;++i)
		{
		elements[i] = 0;
		}

	$('.elements > *').each(function(index)
		{
		$(this).rotate(
			{
			bind:
				{
				dblclick: function()
					{
					elements[index+1] += 45;

					$(this).rotate({animateTo: elements[index+1]});
					}
				}
			});
		});

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7
			});
		});

	/**
	 * Droppable
	 */
	var counter = 0;

	$('.elements').droppable(
		{
		accept: $('.elements > *'),
		addClasses: false,

		drop: function(event,ui)
			{
			++counter;

			ui.helper.css('z-index',counter);
			}
		});
	});
