
$(function()
	{
	/**
	 * jPlayer events
	 */
	$('#jplayer').on($.jPlayer.event.ended,function(event)
		{
		var src = _.last(event.jPlayer.status.src.split('/'));

		if(src === 'file.mp3')
			{
			setTimeout(function()
				{
				$('#jplayer').jPlayer('setMedia', {mp3: './media/desc_1.mp3'}).jPlayer('play');
				$('.elements > .element_1, .elements > .element_2').draggable('option','disabled',false);
				},1000);
			}
		});

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7,
			scope: $this.data('scope'),
			disabled: true
			});
		});

	/**
	 * Droppable
	 */
	var counter = 0;

	$('.boxes > *').each(function()
		{
		var $this = $(this);

		$this.droppable(
			{
			accept: $('.elements > *'),
			addClasses: false,
			scope: $this.data('scope'),

			drop: function(event,ui)
				{
				++counter;
				$(event.target).addClass('ok');

				ui.helper.css('display','none');
				ui.helper.draggable('destroy');

				if((counter > 1) && (counter < 9))
					{
					var scope = ui.helper.data('scope');
					if(scope === 1) scope = 2;

					$('#jplayer').jPlayer('setMedia', {mp3: './media/desc_'+scope+'.mp3'}).jPlayer('play');
					$('.elements > .element_'+(scope+1)).draggable('option','disabled',false);
					}
				}
			});
		});

	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();

		if(counter === 9)
			{
			$('#jplayer_well').jPlayer('play');
			}
		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});
