
$(function()
	{
	/**
	 * Array of elements
	 */
	var elements = [];
	var counter = 0;

	for(var i=1;i<=3;++i) for(var j=1;j<=3;++j)
		{
		elements[counter++] = {'kind': i, 'color': j};
		}

	/**
	 * Place elements in random order
	 */
	$.each(_.shuffle(elements),function(index,value)
		{
		$('.elements').append('<div class="element_'+value.kind+'_'+value.color+'" data-kind="'+value.kind+'" data-color="'+value.color+'" data-dropped="0"/>');
		});

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7
			});
		});

	/**
	 * Droppable
	 */
	var color = [0,0,0], kind = [[0,0,0],[0,0,0],[0,0,0]];

	$('.boxes > *').each(function()
		{
		var $this = $(this);

		$this.droppable(
			{
			accept: $('.elements > *'),
			addClasses: false,
                        tolerance: 'touch',
                        out: function( event, ui )
                                {

                                    if (ui.draggable.data('dropped') === 1)
                                            {
                                            ui.draggable.data('dropped',0);

                                            if (kind[$(event.target).data('color')-1][ui.helper.data('kind')-1] > 0) kind[$(event.target).data('color')-1][ui.helper.data('kind')-1]--;
                                            if(ui.helper.data('color') === $(event.target).data('color'))
                                                {
                                                    color[ui.helper.data('color')-1]--;
                                                }
                                            }
                                },
			drop: function(event,ui)
				{

                                if(ui.draggable.data('dropped') === 0)
                                            {
                                            ui.draggable.data('dropped',1);

                                            kind[$(event.target).data('color')-1][ui.helper.data('kind')-1]++;
                                            if(ui.helper.data('color') === $(event.target).data('color'))
                                                {
                                                    color[ui.helper.data('color')-1]++;
                                                }
                                            }



				}
			});
		});

	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();
		var colorOK = true, kindOK = true;

		for(var i=0;i<3;++i)
			{
			if(color[i] < 3) colorOK = false;

			for(var j=0;j<3;++j)
				{
				if(!((kind[i][j] === 0) || (kind[i][j] === 3)))
					{
					kindOK = false;
					break;
					}
				}

			if((kind[i][0]===0) && (kind[i][1]===0) && (kind[i][2]===0)) kindOK = false;
			}

		if(colorOK)
			{
			$('#jplayer_well').jPlayer('play');
			}
		else if(kindOK)
			{
			$('#jplayer_well').jPlayer('play');
			}
		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});
