
$(function()
	{
	/**
	 * Array of elements
	 */
	var elements = [];
	var counter = 0;

	for(var i=1;i<=4;++i) for(var j=1;j<=2;++j)
		{
		elements[counter++] = {'kind': i, 'item': j};
		}

	/**
	 * Place elements in random order
	 */
	$.each(_.shuffle(elements),function(index,value)
		{
		$('.elements').append('<div class="element_'+value.kind+'_'+value.item+'" data-kind="'+value.kind+'" data-item="'+value.item+'" data-dropped="0"/>');
		});

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7,
			scope: $this.data('item')
			});
		});

	/**
	 * Droppable
	 */
	var kind = [[0,0,0,0],[0,0,0,0],[0,0,0,0],[0,0,0,0]];

	$('.box > *').each(function()
		{
		var $this = $(this);

		$this.droppable(
			{
			accept: $('.elements > *'),
			addClasses: false,
			scope: $this.data('item'),

			drop: function(event,ui)
				{
				if((ui.draggable.data('dropped') === 0) && ($(event.target).data('disabled') === 0))
					{
					ui.draggable.data('dropped',1);

					$(event.target).addClass('ok').addClass(ui.draggable.attr('class')).data('disabled',1);
					$(event.target).parent().addClass('hideInfo');

					ui.draggable.css('background-image','none');

					++kind[$(event.target).data('kind')-1][ui.helper.data('kind')-1];
					}
				},

			out: function(event,ui)
				{
				if(ui.draggable.data('dropped') === 1)
					{
					ui.draggable.data('dropped',0);

					$(event.target).removeClass('ok').removeClass(ui.draggable.attr('class')).data('disabled',0);
					ui.draggable.css('background-image','url(./styles/images/sprite.png)');

					--kind[$(event.target).data('kind')-1][ui.helper.data('kind')-1];
					}
				}
			});
		});

	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();
		var ok = true;

		for(var i=0;i<4;++i)
			{
			for(var j=0;j<4;++j)
				{
				if(!((kind[i][j] === 0) || (kind[i][j] === 2)))
					{
					ok = false;
					break;
					}
				}

			if((kind[i][0]===0) && (kind[i][1]===0) && (kind[i][2]===0) && (kind[i][3]===0)) ok = false;
			}

		if(ok)
			{
			$('#jplayer_well').jPlayer('play');
			}
		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});
