
$(function()
	{
	/**
	 * Elements
	 */
	var elements = [];
	for(var i=1;i<=48;++i)
		{
		elements[i-1] = i;
		}

	$.each(_.shuffle(elements),function(index,value)
		{
		$('.elements').append('<div class="element_'+value+'" data-element="'+value+'"/>');
		});

	/**
	 * Pattern
	 */
	var page = $('.pattern').data('page')-1;
	var pattern = [[34,19,11],[34,8,22,4],[1,12,30,15,41],[46,27,19,33,5,13]];

	$.each(pattern[page],function(index,value)
		{
		$('.pattern').append('<div class="element_'+value+'" data-element="'+value+'"/>');
		});

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7
			});
		});

	/**
	 * Droppable
	 */
	var expressions = [];

	$('.box').droppable(
		{
		accept: $('.elements > *'),
		addClasses: false,

		drop: function(event,ui)
			{
			ui.helper.css('display','none');
			ui.helper.draggable('destroy');

			$('.box').append('<div class="element_'+ui.helper.data('element')+'" data-element="'+ui.helper.data('element')+'"/>');

			expressions[expressions.length] = ui.helper.data('element');
			}
		});

	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();

		var ok = true;

		if(expressions.length !== pattern[page].length)
			{
			ok = false;
			}

		if(ok) for(var i=0;i<pattern[page].length;++i)
			{
			if(expressions[i] !== pattern[page][i])
				{
				ok = false;
				break;
				}
			}

		if(ok)
			{
			$('#jplayer_well').jPlayer('play');
			}

		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});
