
$(function()
	{
	/**
	 * jPlayer
	 */
	if($('main').data('screen') > 1)
		{
		$('#jplayer').on($.jPlayer.event.ready,function()
			{
			$('#jplayer').jPlayer('setMedia', {mp3: './media/file'+$('main').data('screen')+'.mp3'});
			});
		}

	/**
	 * Elements
	 */
	var elements = [];
	for(var i=1;i<=6;++i)
		{
		elements[i-1] = i;
		}

	$.each(_.shuffle(elements),function(index,value)
		{
		$('.elements').append('<div class="element_'+value+'" data-kind="'+value+'" data-dropped="0"/>');
		});

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7
			});
		});

	/**
	 * Droppable
	 */
	var kind = [0,0,0,0,0,0];

	$('.box').droppable(
		{
		accept: $('.elements > *'),
		addClasses: false,

		drop: function(event,ui)
			{
			if(ui.draggable.data('dropped') === 0)
				{
				ui.draggable.data('dropped',1);
				kind[ui.draggable.data('kind')-1] = 1;
				}
			},

		out: function(event,ui)
			{
			if(ui.draggable.data('dropped') === 1)
				{
				ui.draggable.data('dropped',0);
				kind[ui.draggable.data('kind')-1] = 0;
				}
			}
		});

	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();

		var ok = false;

		if(kind[$('.box').data('kind')-1] === 1)
			{
			ok = true;
			}

		for(var i=0;i<6;++i)
			{
			if(i === $('.box').data('kind')-1)
				{
				continue;
				}

			if(kind[i] !== 0)
				{
				ok = false;
				break;
				}
			}

		if(ok)
			{
			$('#jplayer_well').jPlayer('play');
			}
		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});
