
$(function()
	{
	/**
	 * Array of elements
	 */
	var elements = [];

	for(var i=1;i<=8;++i)
		{
		elements[i-1] = i;
		}

	$.each(_.shuffle(elements),function(index,value)
		{
		$('.elements').append('<div class="element_'+value+'" data-element="'+value+'"/>');
		});

	/**
	 * jPlayer
	 */
	var sounds = ['tree','rain','sea','bird','street','driller','door','plane'];
	var counter = 0;

	$('#jplayer').on($.jPlayer.event.ended,function(event)
		{
		$('.sound').fadeIn();

		$('#jplayer_sound').jPlayer(
			{
			ready: function()
				{
				$(this).jPlayer('setMedia', {mp3: './media/tree.mp3'});
				},

			swfPath: '../../styles/flash',
			supplied: 'mp3',
			cssSelectorAncestor: '#jp_container_sound'
			});
		});

	$('#jplayer_well').on($.jPlayer.event.ready,function(event)
		{
		$('#jplayer_well').jPlayer('setMedia', {mp3: './media/well.mp3'})
		});

	/**
	 * Click
	 */
	$('.elements > *').click(function()
		{
		if($(this).data('element')-1 === counter)
			{
			++counter;
			$('#jplayer_well').jPlayer('play');

			if(counter < 8)
				{
				setTimeout(function()
					{
					$('#jplayer_sound').jPlayer('setMedia', {mp3: './media/'+sounds[counter]+'.mp3'}).jPlayer('play');
					},1500);
				}
			else
				{
				setTimeout(function()
					{
					$('.sound').fadeOut();
					$('#jplayer_sound').jPlayer('setMedia', {mp3: './media/'+sounds[0]+'.mp3'});
					},1500);
				}
			}
		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});

