
$(function()
	{
	/**
	 * Array of elements
	 */
	var elements = [];

	for(var i=1;i<=8;++i)
		{
		elements[i-1] = i;
		}

	$.each(_.shuffle(elements),function(index,value)
		{
		$('.elements').append('<div class="element_'+value+'" data-kind="'+(value<5 ? '1' : '2')+'" data-element="'+value+'"/>');
		});

	/**
	 * jPlayer
	 */
	for(var i=1;i<=8;++i)
		{
		$('#jplayer_sound'+i).jPlayer(
			{
			ready: function()
				{
				$(this).jPlayer('setMedia', {mp3: './media/tree.mp3'});
				},

			play: function()
				{
				$(this).jPlayer('pauseOthers');
				},

			swfPath: '../../styles/flash',
			supplied: 'mp3'
			});
		}

	$('#jplayer_sound2').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_sound2').jPlayer('setMedia', {mp3: './media/rain.mp3'});
		});

	$('#jplayer_sound3').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_sound3').jPlayer('setMedia', {mp3: './media/sea.mp3'});
		});

	$('#jplayer_sound4').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_sound4').jPlayer('setMedia', {mp3: './media/bird.mp3'});
		});

	$('#jplayer_sound5').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_sound5').jPlayer('setMedia', {mp3: './media/street.mp3'});
		});

	$('#jplayer_sound6').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_sound6').jPlayer('setMedia', {mp3: './media/driller.mp3'});
		});

	$('#jplayer_sound7').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_sound7').jPlayer('setMedia', {mp3: './media/door.mp3'});
		});

	$('#jplayer_sound8').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_sound8').jPlayer('setMedia', {mp3: './media/plane.mp3'});
		});

	/**
	 * Click
	 */
	$('.elements > *').dblclick(function()
		{
		$('#jplayer_sound'+$(this).data('element')).jPlayer('play');
		});

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7,
			scope: $this.data('kind'),
			revert: true
			});
		});

	/**
	 * Droppable
	 */
	var counter = 0;

	$('.boxes > *').each(function()
		{
		var $this = $(this);

		$this.droppable(
			{
			accept: $('.elements > *'),
			addClasses: false,
			scope: $this.data('kind'),

			drop: function(event,ui)
				{
				++counter;

				ui.helper.draggable('option','revert',false).draggable('disable');
				}
			});
		});

	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();

		if(counter === 8)
			{
			$('#jplayer_well').jPlayer('play');
			}
		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});

