
$(function()
	{
	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7,
			scope: $this.data('scope')
			});
		});

	/**
	 * Droppable
	 */
	var counter = 0;

	$('.boxes > *').each(function()
		{
		var $this = $(this);

		$this.droppable(
			{
			accept: $('.elements > *'),
			addClasses: false,
			scope: $this.data('scope'),
			tolerance: 'touch',
			drop: function(event,ui)
				{
				++counter;

				ui.helper.css('display','none');
				ui.helper.draggable('destroy');

				$(event.target).addClass('ok');
				$(event.target).droppable('disable');
				}
			});
		});

	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();

		if(counter === 6)
			{
			$('#jplayer_well').jPlayer('play');
			}

		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});

