
$(function()
	{
	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		var options =
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7,
			scope: $this.data('color')
			};

		if(($this).data('color') === 2)
			{
			options.revert = true;
			}

		$this.draggable(options);
		});

	/**
	 * Droppable
	 */
	var color = [0,0];

	$('.drop').each(function()
		{
		var $this = $(this);

		$this.droppable(
			{
			accept: $('.elements > *'),
			addClasses: false,
			scope: $this.data('color'),
			tolerance: 'touch',
			drop: function(event,ui)
				{
				$(event.target).addClass('ok').droppable('disable');

				if(ui.helper.data('color') !== 2)
					{
					++color[0];

					ui.helper.css('display','none');
					ui.helper.draggable('destroy');
					}

				else // cat
					{
					++color[1];

					if(color[1] === 5)
						{
						ui.helper.css('display','none');
						ui.helper.draggable('destroy');
						}
					}
				}
			});
		});

	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();

		if((color[0] === 3) && (color[1] === 5))
			{
			$('#jplayer_well').jPlayer('play');
			}

		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});
