
$(function()
	{

	$('#jplayer').on($.jPlayer.event.ready,function()
		{
		$('#jplayer').jPlayer('setMedia', {mp3: './media/file2.mp3'});
		});


	/**
	 * Array of elements
	 */
	var elements = [];
	var counter = 0;

	for(var i=1;i<=3;++i) for(var j=1;j<=2;++j)
		{

		elements[counter++] = {'kind': i, 'item': j};
		}

	/**
	 * Place elements in random order
	 */
	$.each(_.shuffle(elements),function(index,value)
		{
		$('.elements').append('<div class="element_'+value.kind+'_'+value.item+'" data-kind="'+value.kind+'" data-item="'+value.item+'" data-dropped="0" />');
		});

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7
                        });
		});

	/**
	 * Droppable
	 */
	var kind = [[0,0,0],[0,0,0],[0,0,0]];

	$('.boxes > *').each(function()
		{
		var $this = $(this);

		$this.droppable(
			{
			accept: $('.elements > *'),
    			addClasses: false,
                        out: function( event, ui )
                                {

                                    if (ui.draggable.data('dropped') === 1)
                                            {
                                            ui.draggable.data('dropped',0);

                                            if (kind[$(event.target).data('kind')-1][ui.helper.data('kind')-1] > 0) kind[$(event.target).data('kind')-1][ui.helper.data('kind')-1]--;

                                            }
                                },

			drop: function(event,ui)
				{

                                     if (ui.draggable.data('dropped') === 0)
                                            {
                                            ui.draggable.data('dropped',1);

                                            kind[$(event.target).data('kind')-1][ui.helper.data('kind')-1]++;

                                               }
				}

			});
		});

	/**
	 * Click
	 */
	var clicked = 0;

	$('.basket').click(function()
		{
		//$('.basket').off('click');


                $('.click').each(function()
                {
                  $(this).removeClass('click');
                });



		if ($(this).hasClass('click'))
                        {
                        $(this).removeClass('click');
                        clicked= null;
                        } else {
                                    clicked = $(this).parent().data('kind');
                                    $(this).addClass('click');
                                }

                });

	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();
		var ok = false;



		if((kind[0][0]===2) && (kind[1][1]===2) && (kind[2][2]===2)) ok = true;


		if (ok)
			{
			$('#jplayer_well').jPlayer('play');
			}
		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});
