
$(function()
	{
	/**
	 * Elements
	 */

	var counter=0,interval,roll=6,rollCount=0;

	for(var i=1;i<=10;++i)
		{
		$('.elements').append('<div class="element" data-dropped="0"/>');
		}


	$('.btn').mousedown(function(){
		interval = setInterval(function() { rollDice(); }, 150);
	    }).mouseup(function() {
		clearInterval(interval);
	    });
	$('.btn').mouseout(function(){
		clearInterval(interval);
	});

	function rollDice()
		{
		$('.dice').attr('class', 'dice');
		roll=Math.floor((Math.random() * 6) + 1);
		$('.dice').addClass('dice' + roll);
		if (rollCount++ > 80)
			{
				clearInterval(interval);
				rollCount=0;
			}

		}

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7
			});
		});

	/**
	 * Droppable
	 */


	$('.box').droppable(
		{
		accept: $('.elements > *'),
		addClasses: false,
		drop: function(event,ui)
			{
			if (ui.draggable.attr('data-dropped') === "0")
				{
				ui.draggable.attr( 'data-dropped', "1");
				++counter;
				}
			},
		out: function(event,ui)
			{
			if (ui.draggable.attr('data-dropped') === "1")
				{
				ui.draggable.attr( 'data-dropped', "0");
				--counter;
				}

			}
		});



	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();
		if(counter === roll + 3)
			{
			$('#jplayer_well').jPlayer('play');
			$("#jplayer_well").bind($.jPlayer.event.ended, function() {
							location.reload();
							});
			}
		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});
