
$(function()
	{
	/**
	 * Elements
	 */
	var elements = [];
	for(var i=1;i<=30;++i)
		{
		elements[i-1] = i;
		}

	$.each(_.shuffle(elements),function(index,value)
		{
                 var rand = Math.floor((Math.random() * 2) + 1);

		$('.elements').append('<div class="element_'+rand+'" data-dropped="0" data-element="'+rand+'"/>');
		});

	/**
	 * Pattern
	 */
	var page = $('.pattern').data('page')-1;
	var pattern = [[1,2,1,1,1,1,2],[2,1,2,2,1,2],[2,2,1,1,2]];

	$.each(pattern[page],function(index,value)
		{
		$('.pattern').append('<div class="element_'+value+'" data-element="'+value+'"/>');
		$('.boxes').append('<div class="box" data-element="'+value+'"></div>')
		});

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7
			});
		});

	/**
	 * Droppable
	 */
	var counter = 0;

	$('.box').droppable(
		{
		accept: $('.elements > *'),
		addClasses: false,
		out: function(event,ui)
                                {

					if (ui.draggable.data('dropped') === 1)
						{
						ui.draggable.data('dropped',0);

						  if ($(event.target).data('element') === ui.draggable.data('element')) counter--;

							console.log(counter);

						}

                                },
		drop: function(event,ui)
			{


			if (ui.draggable.data('dropped') === 0)
						{
						    ui.draggable.data('dropped',1);

						    if ($(event.target).data('element') === ui.draggable.data('element')) counter++;

							console.log(counter);


						}

			}
		});

	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();

		var ok = true;

		if(counter !== pattern[page].length)
			{
			ok = false;
			}

		if(ok)
			{
			$('#jplayer_well').jPlayer('play');
			}

		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});
