
$(function()
	{
	/**
	 * Elements
	 */
	var elements = [];
	for(var i=1;i<=5;++i)
		{
		elements[i-1] = i;
		}

	$.each(_.shuffle(elements),function(index,value)
		{
		$('.elements').append('<div class="element_'+value+'" data-scope="'+value+'"/>');
		});

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7,
			scope: $this.data('scope')
			});
		});

	/**
	 * Droppable
	 */
	var counter = 0;

	$('.box').each(function()
		{
		var $this = $(this);

		$this.droppable(
			{
			accept: $('.elements > *'),
			addClasses: false,
			scope: $this.data('scope'),

			drop: function(event,ui)
				{
				ui.helper.draggable('disable');
				++counter;
				}
			});
		});

	/**
	 * jPlayer
	 */
	for(var i=1;i<=5;++i)
		{
		$('#jplayer_melody'+i).jPlayer(
			{
			ready: function()
				{
				$(this).jPlayer('setMedia', {mp3: './media/melody_1.mp3'});
				},

			play: function()
				{
				$(this).jPlayer('pauseOthers');
				},

			swfPath: '../../styles/flash',
			supplied: 'mp3',
			cssSelectorAncestor: '#jp_container_melody'+i
			});
		}

	$('#jplayer_melody2').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_melody2').jPlayer('setMedia', {mp3: './media/melody_2.mp3'});
		});

	$('#jplayer_melody3').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_melody3').jPlayer('setMedia', {mp3: './media/melody_3.mp3'});
		});

	$('#jplayer_melody4').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_melody4').jPlayer('setMedia', {mp3: './media/melody_4.mp3'});
		});

	$('#jplayer_melody5').on($.jPlayer.event.ready,function()
		{
		$('#jplayer_melody5').jPlayer('setMedia', {mp3: './media/melody_5.mp3'});
		});

	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();

		if(counter === 5)
			{
			$('#jplayer_well').jPlayer('play');
			}
		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});
