
$(function()
	{

	/**
	 * Elements
	 */
	var elements = [];
	for(var i=1;i<=9;++i)
		{
		elements[i-1] = i;
		}

	$.each(_.shuffle(elements),function(index,value)
		{
		$('.elements').append('<div class="element_'+value+'" data-element="'+value+'"/>');
		});

	/**
	 * Draggable
	 */
	$('.elements > *').each(function()
		{
		var $this = $(this);

		$this.draggable(
			{
			containment: $('main'),
			cursor: 'move',
			opacity: .7,
			scope: $this.data('element')
			});
		});

	/**
	 * Droppable
	 */
	var counter = 0;

	$('.boxes > *').each(function()
		{
		var $this = $(this);

		$this.droppable(
			{
			accept: $('.elements > *'),
			addClasses: false,
			scope: $this.data('kind'),

			drop: function(event,ui)
				{
				++counter;

				$(event.target).addClass('ok').droppable('disable');
				ui.helper.css('display','none').draggable('destroy');
				}
			});
		});
	/**
	 * Hint
	 */
	$('a.hint').click(function(e)
		{
		e.preventDefault();
		$('div.hint').fadeToggle();
		});



	/**
	 * Check
	 */
	$('.footer_game .check').click(function(e)
		{
		e.preventDefault();

		if(counter === 9)
			{
			$('#jplayer_well').jPlayer('play');
			}
		else
			{
			$('#jplayer_wrong').jPlayer('play');
			}
		});
	});
