$(function()
{
	var gameMode = $('main').data("mode");
	if(gameMode == 1) {
		var bookValues = _.range(2, 21, 2) ;
		var nextBookVal = 2;
	} else {
		var bookValues = _.range(1, 20, 2) ;
		var nextBookVal = 1;
	}
	shuffleArray(bookValues);
	var bookCount = 0;
	
	for(var i=0; i<10; i++) {
		var left = 220 + (60*i);
		$('.elements').append('<div style="top: 360px; left: '+left+'px" class="books book-'+i+'" data-value="'+bookValues[i]+'" data-id="'+i+'"><div class="text_inside">'+bookValues[i]+'</div></div>');		
	}
	
	$(".books").draggable({ revert: true });
	
	$("#targetbox").droppable({
        drop: function(event, ui) {
			if(ui.draggable.data("value") == nextBookVal) {
				var id = ui.draggable.data("id");
				ui.draggable.remove();
				$('.elements').append('<div style="position: relative;" class="book-'+id+'"><div class="text_inside">'+nextBookVal+'</div></div>');	
				nextBookVal+=2;
				bookCount++;
				if(bookCount == 10) $('#jplayer_well').jPlayer('play');
			} else {
				$('#jplayer_wrong').jPlayer('play');	
			}
		}
	});
	
	function shuffleArray(array) {
		for (var i = array.length - 1; i > 0; i--) {
			var j = Math.floor(Math.random() * (i + 1));
			var temp = array[i];
			array[i] = array[j];
			array[j] = temp;
		}
		return array;
	}
});
