$(function()
{
	var products = [
		[0,1,20], [1,1,20], [2,1,20], [3,1,20], [22,1,20],
		[4,2,7], [5,2,7], [6,2,7], [7,2,7],
		[8,3,20], [9,3,20], [10,3,20], [11,3,20],
		[12,4,-1], [13,4,-1], [14,4,-1],
		[15,5,-35], [16,5,-35], [17,5,-35], [18,5,-35], [19,5,-35],
		[20,6,-35], [21,6,-35]
	];
	var count = 0;
	shuffleArray(products);

	for(var i=0; i<23; i++) {
		$('.itembox').append('<div class="item element'+products[i][0]+'" data-target="'+products[i][1]+'" data-margin="'+products[i][2]+'"></div>');
	}
	$(".item").draggable({ revert: true });

	$(".targetbox").droppable({
        drop: function(event, ui) {
			if(ui.draggable.data("target") == $(this).data("value")) {
                ui.draggable.clone(true).css("left", "0px").css("top", "0px").css('margin-left', ui.draggable.data("margin")).appendTo($(this));

				ui.draggable.remove();
				count++;
				if(count == 23) {
					$('#jplayer_well').jPlayer('play');
				}
			} else {
				$('#jplayer_wrong').jPlayer('play');
			}
		}
	});

	function shuffleArray(array) {
		for (var i = array.length - 1; i > 0; i--) {
			var j = Math.floor(Math.random() * (i + 1));
			var temp = array[i];
			array[i] = array[j];
			array[j] = temp;
		}
		return array;
	}
});
