$(function ()
{
    var zindex = 10;
    var top;
    var left;

    for (var i = 0; i < 20; i++) {
        left = 850;
        top = 50 + (i * 40);
        if (i > 9) {
            left = 890;
            top = 50 + ((i - 10) * 40);
        }
        $('main').append('<div style="left:' + left + 'px;top:' + top + 'px;" class="textbox dragg" data-dropped="0" data-value="' + (i + 1) + '">' + (i + 1) + '</div>');
    }

    $(".dragg").draggable({
        start: function () {
            zindex++;
            $(this).css('z-index', zindex);
        },
        revertDuration: 1200,
        revert: function () {
            if ($(this).hasClass('building')) {
                return true;
            } else {
                return false;
            }
        }
    });

    var drop = function (event, ui) {
        if (ui.draggable.data('dropped') === 0) {
            ui.draggable.data('dropped', 1);
            $(this).data('value', ui.draggable.data('value'));
        }
    };

    var out = function (event, ui) {
        if (ui.draggable.data('dropped') === 1) {
            ui.draggable.data('dropped', 0);
            $(this).data('value', 0);
        }
    };

    $(".target").droppable({
        accept: ".textbox",
        tolerance: "pointer",
        drop: drop,
        out: out
    });

    $(".ruller").droppable({
        accept: ".building",
        tolerance: "pointer",
        drop: drop
    });
});