
$(function () {

    pathNo = 0;
    var zindex = 10;
    var top;
    var left;
    var coords = [],
	    dotCheck,
	    collection = 0,
	    width = 1024,
	    height = 611,
	    line = d3.svg.line(),
	    dragStart = function () {
		coords = [];
		collection = 0;
		pathNo++;
		if (pathNo === 3) {
		    g.selectAll("path").remove();
		    pathNo = 1;
		}
	    },
	    drawPath = function (terminator) {
		g.append("path").attr({
		    d: line(coords),
		    zbior: pathNo
		});
		if (terminator) {
		    g.select("#terminator").remove();
		    g.append("path").attr({
			id: "terminator",
			d: line([coords[0], coords[coords.length - 1]]),
			zbior: pathNo
		    });
		}
	    },
	    dragMove = function () {
		dot.classed("selected", false);
		coords.push(d3.mouse(this));
		dot.each(function (d, i) {
		    point = [d3.select(this).attr("cx"), d3.select(this).attr("cy")];
		    if (pointInPolygon(point, coords)) {
			d3.select(this).classed("selected", true);
		    }
		});
		drawPath();
	    },
	    check1 = function () {
		dotCheck = g.selectAll("circle")[0];
		for (i = 0; i < 18; i++) {
		    var cl = dotCheck[i].attributes.class.value;
		    if (cl === "selected") {
			var txt = dotCheck[i].attributes.valueL.value;
			var v = parseInt(txt);

			collection += v;
		    }
		}
		if (collection === 750 || collection === 56) {
		    $('#jplayer_well').jPlayer('play');
		    if (pathNo === 2) {
			drag.on("dragstart", null)
				.on("drag", null)
				.on("dragend", null);
		    }
		} else {
		    $('#jplayer_wrong').jPlayer('play');
		    g.selectAll("path[zbior='" + pathNo + "']").remove();
		    pathNo--;
		}
	    },
	    dragEnd = function () {
		drawPath(true);
		check1();
	    };


    drag = d3.behavior.drag()
	    .on("dragstart", dragStart)
	    .on("drag", dragMove)
	    .on("dragend", dragEnd),
// from https://github.com/substack/point-in-polygon
	    pointInPolygon = function (point, vs) {
// ray-casting algorithm based on
// http://www.ecse.rpi.edu/Homepages/wrf/Research/Short_Notes/pnpoly.html
		var xi, xj, i, intersect,
			x = point[0],
			y = point[1],
			inside = false;
		for (var i = 0, j = vs.length - 1; i < vs.length; j = i++) {
		    xi = vs[i][0],
			    yi = vs[i][1],
			    xj = vs[j][0],
			    yj = vs[j][1],
			    intersect = ((yi > y) !== (yj > y))
			    && (x < (xj - xi) * (y - yi) / (yj - yi) + xi);
		    if (intersect)
			inside = !inside;
		}
		return inside;
	    },
	    svg = d3.select("#canvas").append("svg").attr({
	width: width,
	height: height
    }).call(drag),
	    g = svg.append("g"),
	    point = {
		0: {x: 72, y: 87, c: 1},
		1: {x: 84, y: 252, c: 1},
		2: {x: 161, y: 439, c: 1},
		3: {x: 376, y: 269, c: 1},
		4: {x: 348, y: 444, c: 1},
		5: {x: 517, y: 463, c: 1},
		6: {x: 272, y: 83, c: 10},
		7: {x: 451, y: 102, c: 10},
		8: {x: 508, y: 327, c: 10},
		9: {x: 640, y: 442, c: 10},
		10: {x: 645, y: 144, c: 10},
		11: {x: 692, y: 284, c: 100},
		12: {x: 775, y: 64, c: 100},
		13: {x: 940, y: 137, c: 100},
		14: {x: 836, y: 232, c: 100},
		15: {x: 771, y: 352, c: 100},
		16: {x: 949, y: 309, c: 100},
		17: {x: 853, y: 491, c: 100}
	    },
    points = function (numPoints) {
	var data = [];
	for (i = 0; i < numPoints; i++) {
	    data.push({x: point[i]["x"], y: point[i]["y"], c: point[i]["c"]});
	}
	return data;
    },
	    dot = g.selectAll("circle")
	    .data(points(18))
	    .enter().append("circle")
	    .attr({
		cx: function (d, i) {
		    return d.x;
		},
		cy: function (d, i) {
		    return d.y;
		},
		r: 10,
		valueL: function (d, i) {
		    return d.c;
		},
		class: ""
	    });


    d3.select("#clear").on("click", function () {
	dot.classed("selected", false);
	dragStart();
    });

    for (var i = 1; i <= 10; i++) {
	left = 78 + ((i - 1) * 87);
	top = 525;
	if (i > 5) {
	    left = 78 + ((i - 6) * 87);
	    top = 567;
	}
	$('main').append('<div style="left:' + left + 'px;top:' + top + 'px;" class="textbox dragg" data-dropped="0" data-target="0" data-value="' + i + '">' + i + '</div>');
    }

    $(".dragg").draggable({
	start: function () {
	    zindex++;
	    $(this).css('z-index', zindex);
	}
    });

    var drop = function (event, ui) {
	if (ui.draggable.data('dropped') === 0) {
	    ui.draggable.data('dropped', 1);
	    var x = $(this).data('value');
	    var y = ui.draggable.data('value');
	    $(this).data('value', x + y);
	    check2();
	}
    };

    var out = function (event, ui) {
	if (ui.draggable.data('dropped') === 1) {
	    ui.draggable.data('dropped', 0);
	    var x = $(this).data('value');
	    var y = ui.draggable.data('value');
	    $(this).data('value', x - y);
	    check2();
	}
    };

    $(".target").droppable({
	accept: ".textbox",
	tolerance: "pointer",
	drop: drop,
	out: out
    });

    function check2() {
	var t = $(".target").data('value');
	if (t === 5) {
	    $('#jplayer_well').jPlayer('play');
	    $(".dragg").draggable("option", {disabled: true});
	} else {
	    if (t !== 0) {
		$('#jplayer_wrong').jPlayer('play');
	    }
	}
    }
});