$(function ()
{
    var zindex = 10;
    var left = 0;
    var top = 0;

    function setDragg() {
        var nr = {1: 18, 2: 13, 3: 20, 4: 13};
        for (var prop in nr) {
            left = 320 + (prop * 54);
            top = 380;
            $('main').append('<div style="left:' + left + 'px;top:' + top + 'px;" class="textbox dragg sprite dr" data-dropped="0" data-value="' + nr[prop] + '">' + nr[prop] + '</div>');
        }

        $(".dragg").draggable({
            start: function () {
                zindex++;
                $(this).css('z-index', zindex);
                left = $(this).css('left');
                top = $(this).css('top');
            }
        });
    }

    setDragg();

    var drop = function (event, ui) {
        if (ui.draggable.data('dropped') === 0)
        {
            ui.draggable.data('dropped', 1);
            $(this).data('value', ui.draggable.data('value'));
            $(this).data('ok', 1);

            if (
                    $("#z1 .t11").data('ok') !== 0 &&
                    $("#z1 .t12").data('ok') !== 0 &&
                    $("#z1 .t13").data('ok') !== 0 &&
                    $("#z1 .t14").data('ok') !== 0
                    ) {
                check();
            }
        }
    };
    var out = function (event, ui) {
        if (ui.draggable.data('dropped') === 1) {
            ui.draggable.data('dropped', 0);
            $(this).data('value', 0);
            $(this).data('ok', 0);
        }

    };
    $(".target").droppable({
        accept: ".textbox",
        tolerance: "pointer",
        drop: drop,
        out: out
    });

    function check() {
        var a = $(".t11").data('value');
        var b = $(".t12").data('value');
        var c = $(".t13").data('value');
        var d = $(".t14").data('value');
        if (a === 20 && b === 18 && c === 13 && d === 13)
        {
            $('#jplayer_well').jPlayer('play');
        } else {
            $("#z1 *").data('value', 0);
            $("#z1 *").data('ok', 0);
            $(".dragg").remove();
            setDragg();
            $('#jplayer_wrong').jPlayer('play');
        }
    }
});