$(function ()
{
	
	var instance;
	var connections = [],
		updateConnections = function (conn, remove) {
			if (!remove)
				connections.push(conn);
			else {
				var idx = -1;
				for (var i = 0; i < connections.length; i++) {
					if (connections[i] === conn) {
						idx = i;
						break;
					}
				}
				if (idx !== -1)
					connections.splice(idx, 1);
			}
			if (connections.length >= 13) {
				var ok = true;
				for (var j = 0; j < connections.length; j++) {
					if (connections[j].sourceId.substring(1, 3) !== connections[j].targetId.substring(1, 3))
						ok = false;
				}
				if (ok) {
					$('#jplayer_well').jPlayer('play');
					instance.reset();
					$('main > *').fadeOut(function () {
						$(this).remove()
					})
					part2();
				}
				else
					$('#jplayer_wrong').jPlayer('play');
			}
		};

	jsPlumb.ready(function () {
		var Color = "#f7cc4a";
		instance = jsPlumb.getInstance({
			DragOptions: {cursor: 'pointer', zIndex: 2000},
			EndpointHoverStyle: {fillStyle: "green"},
			HoverPaintStyle: {strokeStyle: "green", dashstyle: "0"},
			Container: "main"
		});


		instance.doWhileSuspended(function () {

			instance.bind("connection", function (info, originalEvent) {
				updateConnections(info.connection);
			});
			instance.bind("connectionDetached", function (info, originalEvent) {
				updateConnections(info.connection, true);
			});

			instance.bind("connectionMoved", function (info, originalEvent) {
				updateConnections(info.connection, true);
			});

			var DropOptions = {
				tolerance: "touch"
			};

			var dynamicAnchors = ["Bottom", "Left", "Top", 'Right'];
			var Endpoint = {
				endpoint: ["Dot", {radius: 11}],
				paintStyle: {fillStyle: Color},
				isSource: true,
				reattach: false,
				scope: "target",
				anchor: dynamicAnchors,
				connectorStyle: {
					gradient: {stops: [[0, Color], [0.3, "#fff"], [0.6, "#fff"], [1, Color]]},
					lineWidth: 4,
					strokeStyle: Color,
					dashstyle: "2 1"
				},
				maxConnections: 2,
				isTarget: true,
				dropOptions: DropOptions
			};

			instance.addEndpoint(jsPlumb.getSelector(".target"), Endpoint);

		});

	});


	function part2() {

		$('main').append('<div class="elements"></div>');
		var elements = [[1, "styczeń"], [2, "luty"], [3, "marzec"], [4, "kwiecień"], [5, "maj"], [6, "czerwiec"], [7, "lipiec"], [8, "sierpień"], [9, "wrzesień"], [10, "październik"], [11, "listopad"], [12, "grudzień"]];
		shuffleArray(elements);
		for (var i = 0; i < 12; i++) {
			$('.elements').append('<div class="data" data-value="' + elements[i][0] + '"><span>' + elements[i][1] + '</span></div>');
		}
		var str = '';
		$(".elements").sortable({
			revert: true,
			axis: "y",
			stop: function( event, ui )
			{
				var str = '';
				$('.data').each(function () {
					str += $(this).data("value");
				});
				if (str === "123456789101112")
				$('#jplayer_well').jPlayer('play');
			}
		});
	}

	$('.check').click(function(){
		var str = '';
		$('.data').each(function () {
			str += $(this).data("value");
		});
		if (str === "123456789101112")
			$('#jplayer_well').jPlayer('play');
		else
			$('#jplayer_wrong').jPlayer('play');
	});


	function shuffleArray(array) {
		for (var i = array.length - 1; i > 0; i--) {
			var j = Math.floor(Math.random() * (i + 1));
			var temp = array[i];
			array[i] = array[j];
			array[j] = temp;
		}
		return array;
	}

});