$(function () {
    var zindex = 10,
	    drop = function (event, ui) {
		if ($(this).data('value') !== ui.draggable.data('value') || ui.draggable.data('value') !== 25) {
		    $('#jplayer_wrong').jPlayer('play');
		} else {
		    ui.draggable
			    .draggable({revert: false})
			    .draggable({disabled: true});
		    var position = $(this).position();
		    ui.draggable
			    .css('top', position.top + ($(this).height() - ui.draggable.height()) / 5 * 4)
			    .css('left', position.left + ($(this).width() - ui.draggable.width()) / 5 * 4);
		    $(this).addClass('focus');
		    $('#jplayer_well').jPlayer('play');
		    animateJas(0);
		}
	    };

    /**
     * 
     * @param {number} count
     * @returns {undefined}
     * @description Animuje Jasia
     */
    function animateJas(count) {
	$(".jas-1").addClass('jas-2');
	$(".jas-1").animate({
	    top: 52},
	{
	    duration: 400,
	    easing: 'easeInOutCubic'});
	$(".jas-1").animate({
	    top: 153},
	{
	    duration: 400,
	    easing: 'easeInOutCubic',
	    complete: function () {
		$(".jas-1").removeClass('jas-2');
	    }});
	setTimeout(function () {
	    count++;
	    if (count < 3) {
		animateJas(count);
	    }
	}, 1000);
    }

    $('.dragg').draggable({
	start: function () {
	    zindex++;
	    $(this).css('z-index', zindex);
	},
	revert: true,
	revertDuration: 800
    });

    $(".dropp").droppable({
	accept: '.dragg',
	tolerance: "pointer",
	drop: drop
    });
});