$(function () {

    var zindex = 10;
    var accept = {
	'element-1': [14],
	'element-2': [24],
	'element-3': [30],
	'element-4': [21],
	'element-5': [0],
	'element-6': [10],
	'element-7': [18],
	'element-8': [9],
	'element-9': [5],
	'element-10': [15],
	'element-11': [20]
    };

    $(".textbox").draggable({
	start: function () {
	    zindex++;
	    $(this).css('z-index', zindex);
	},
	revert: true,
	revertDuration: 800
    });

    var drop = function (event, ui) {
	var task = $(this).attr('id');
	var acc = accept[task].indexOf(ui.draggable.data('value'));
	if (acc >= 0) {
	    accept[task].splice(acc, 1);
	    ui.draggable
		    .draggable({revert: false})
		    .draggable({disabled: true});
	    $(this).droppable({accept: null});

	    $('#jplayer_well').jPlayer('play');
	}
	else {
	    $('#jplayer_wrong').jPlayer('play');
	}
    };

    $(".element").droppable({
	accept: ".textbox",
	tolerance: "intersect",
	drop: drop
    });
});