$(function () {

    var zindex = 10;
    var accept = {
	'element-1': [28],
	'element-2': [7]
    };

    $(".textbox").draggable({
	start: function () {
	    zindex++;
	    $(this).css('z-index', zindex);
	},
	revert: true,
	revertDuration: 800
    });

    var drop = function (event, ui) {
	var task = $(this).attr('id');
	var acc = accept[task].indexOf(ui.draggable.data('value'));
	if (acc >= 0) {
	    accept[task].splice(acc, 1);
	    	    var position = $(this).position();
	    ui.draggable
		    .css('top', position.top + ($(this).height() - ui.draggable.height())/2)
		    .css('left', position.left + ($(this).width() - ui.draggable.width())/2);
	    ui.draggable
		    .draggable({revert: false})
		    .draggable({disabled: true});
	    $(this).droppable({accept: null});

	    $('#jplayer_well').jPlayer('play');
	}
	else {
	    $('#jplayer_wrong').jPlayer('play');
	}
    };

    $(".element").droppable({
	accept: ".textbox",
	tolerance: "pointer",
	drop: drop
    });
});