$(function() {

    var zindex = 10,
            box = 0,
            top,
            left,
            elements = [3, 8, 11, 14, 20],
            drop = function(event, ui) {
                if ($(this).data('value') === ui.draggable.data('value')) {
                    $('#jplayer_well').jPlayer('play');
                    var position = $(this).position();
                    ui.draggable
                            .css('left', position.left)
                            .css('top', position.top)
                            .draggable({revert: false})
                            .draggable("option", "disabled", true);
                    box++;
                    makeDroppable(box);
                }
                else {
                    $('#jplayer_wrong').jPlayer('play');
                }
            };

    function makeDroppable(box) {
        $("#box" + elements[box]).droppable({
            accept: ".dragg",
            tolerance: "pointer",
            drop: drop
        });
        var position = $("#box" + elements[box]).position();
        $('.arrow')
                .css('left', position.left)
                .css('top', position.top - 35);
    }

    function romanize(num) {
        var lookup = {X: 10, IX: 9, V: 5, IV: 4, I: 1},
        roman = '',
                i;
        for (i in lookup) {
            while (num >= lookup[i]) {
                roman += i;
                num -= lookup[i];
            }
        }
        return roman;
    }

    for (var i = 1; i <= 20; i++) {
        var text = (elements.indexOf(i) === -1) ? romanize(i) : '';
        left = 2 + ((i - 1) * 51);
        top = 395 - 8 * i; 

        $('main').append('<div id="box' + i + '" style="left:' + left + 'px;top:' + top + 'px;" class="textbox" data-value="' + i + '">' + text + '</div>');
    }
    for (var j in elements) {
        $('main').append('<div id="dragg' + elements[j] + '" class="textbox dragg" data-value="' + elements[j] + '">' + romanize(elements[j]) + '</div>');
    }


    $(".dragg").draggable({
        start: function() {
            zindex++;
            $(this).css('z-index', zindex);
        },
        revertDuration: 900,
        revert: true
    });

    makeDroppable(box);
});