/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HlineAtom;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.MulticolumnAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXParser;
import org.scilab.forge.jlatexmath.VerticalBox;
import org.scilab.forge.jlatexmath.VlineAtom;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MatrixAtom
extends Atom {
    public static SpaceAtom a = new SpaceAtom(0, 2.0f, 0.0f, 0.0f);
    public static SpaceAtom b = new SpaceAtom(0, 1.0f, 0.0f, 0.0f);
    public static SpaceAtom c = new SpaceAtom(1, 0.0f, 1.0f, 0.0f);
    public static SpaceAtom d = new SpaceAtom(1, 0.0f, 0.4f, 0.0f);
    public static SpaceAtom e = new SpaceAtom(1, 0.0f, 0.4f, 0.0f);
    private static final Box a = new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
    private ArrayOfAtoms a;
    private int[] a;
    private Map a;
    private int d;
    private boolean a = new HashMap();
    private static SpaceAtom f = new SpaceAtom(2);

    public MatrixAtom(boolean bl, ArrayOfAtoms arrayOfAtoms, String string) {
        this.a = bl;
        this.a = arrayOfAtoms;
        this.d = 0;
        this.parsePositions(new StringBuffer(string));
    }

    public MatrixAtom(ArrayOfAtoms arrayOfAtoms, String string) {
        this(false, arrayOfAtoms, string);
    }

    public MatrixAtom(boolean bl, ArrayOfAtoms arrayOfAtoms, int n) {
        this.a = bl;
        this.a = arrayOfAtoms;
        this.d = n;
        if (n != 1 && n != 5) {
            this.a = new int[this.a.a];
            for (int i = 0; i < this.a.a; i += 2) {
                this.a[i] = 1;
                if (i + 1 >= this.a.a) continue;
                this.a[i + 1] = 0;
            }
        } else {
            this.a = new int[this.a.a];
            for (int i = 0; i < this.a.a; ++i) {
                this.a[i] = 2;
            }
        }
    }

    public MatrixAtom(boolean bl, ArrayOfAtoms arrayOfAtoms, int n, int n2) {
        this.a = bl;
        this.a = arrayOfAtoms;
        this.d = n;
        this.a = new int[this.a.a];
        for (int i = 0; i < this.a.a; ++i) {
            this.a[i] = n2;
        }
    }

    public MatrixAtom(ArrayOfAtoms arrayOfAtoms, int n) {
        this(false, arrayOfAtoms, n);
    }

    private void parsePositions(StringBuffer stringBuffer) {
        int n;
        int n2 = stringBuffer.length();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        block8: for (int i = 0; i < n2; ++i) {
            char c2 = stringBuffer.charAt(i);
            switch (c2) {
                case 'l': {
                    arrayList.add(0);
                    continue block8;
                }
                case 'r': {
                    arrayList.add(1);
                    continue block8;
                }
                case 'c': {
                    arrayList.add(2);
                    continue block8;
                }
                case '|': {
                    n = 1;
                    while (++i < n2) {
                        c2 = stringBuffer.charAt(i);
                        if (c2 != '|') {
                            --i;
                            break;
                        }
                        ++n;
                    }
                    this.a.put(arrayList.size(), new VlineAtom(n));
                    continue block8;
                }
                case '@': {
                    TeXFormula teXFormula = new TeXFormula();
                    TeXParser teXParser = new TeXParser(this.a, stringBuffer.substring(++i), teXFormula, false);
                    Atom atom = teXParser.getArgument();
                    ++this.a.a;
                    for (int j = 0; j < this.a.b; ++j) {
                        ((LinkedList)this.a.a.get(j)).add(arrayList.size(), atom);
                    }
                    arrayList.add(5);
                    i += teXParser.getPos();
                    --i;
                    continue block8;
                }
                case '*': {
                    TeXFormula teXFormula = new TeXFormula();
                    TeXParser teXParser = new TeXParser(this.a, stringBuffer.substring(++i), teXFormula, false);
                    String[] stringArray = teXParser.getOptsArgs(2, 0);
                    i += teXParser.getPos();
                    int n3 = Integer.parseInt(stringArray[1]);
                    String string = "";
                    for (int j = 0; j < n3; ++j) {
                        string = string + stringArray[2];
                    }
                    stringBuffer.insert(i, string);
                    n2 = stringBuffer.length();
                    --i;
                    continue block8;
                }
                default: {
                    arrayList.add(2);
                }
            }
        }
        for (n = arrayList.size(); n < this.a.a; ++n) {
            arrayList.add(2);
        }
        if (arrayList.size() != 0) {
            Integer[] integerArray = arrayList.toArray(new Integer[0]);
            this.a = new int[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                this.a[i] = integerArray[i];
            }
        } else {
            this.a = new int[]{2};
        }
    }

    public Box[] getColumnSep(TeXEnvironment teXEnvironment, float f) {
        int n = this.a.b;
        int n2 = this.a.a;
        Box[] boxArray = new Box[n2 + 1];
        float f2 = teXEnvironment.getTextwidth();
        if (this.d == 6 || this.d == 7) {
            f2 = Float.POSITIVE_INFINITY;
        }
        switch (this.d) {
            case 0: {
                int n3 = 1;
                if (this.a[0] == 5) {
                    boxArray[1] = new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
                    n3 = 2;
                }
                boxArray[0] = b.createBox(teXEnvironment);
                boxArray[n2] = boxArray[0];
                Box box = a.createBox(teXEnvironment);
                while (n3 < n2) {
                    if (this.a[n3] == 5) {
                        boxArray[n3] = new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
                        boxArray[n3 + 1] = boxArray[n3];
                        ++n3;
                    } else {
                        boxArray[n3] = box;
                    }
                    ++n3;
                }
                return boxArray;
            }
            case 1: 
            case 5: {
                boxArray[0] = a;
                boxArray[n2] = boxArray[0];
                Box box = a.createBox(teXEnvironment);
                for (int i = 1; i < n2; ++i) {
                    boxArray[i] = box;
                }
                return boxArray;
            }
            case 2: 
            case 6: {
                Box box;
                Box box2 = MatrixAtom.f.createBox(teXEnvironment);
                if (f2 != Float.POSITIVE_INFINITY) {
                    float f3 = Math.max((f2 - f - (float)(n2 / 2) * box2.getWidth()) / (float)Math.floor((n2 + 3) / 2), 0.0f);
                    box = new StrutBox(f3, 0.0f, 0.0f, 0.0f);
                } else {
                    box = a.createBox(teXEnvironment);
                }
                boxArray[n2] = box;
                for (int i = 0; i < n2; ++i) {
                    boxArray[i] = i % 2 == 0 ? box : box2;
                }
                break;
            }
            case 3: 
            case 7: {
                float f4 = f2 != Float.POSITIVE_INFINITY ? Math.max((f2 - f) / 2.0f, 0.0f) : 0.0f;
                Box box = MatrixAtom.f.createBox(teXEnvironment);
                Box box3 = a;
                boxArray[0] = new StrutBox(f4, 0.0f, 0.0f, 0.0f);
                boxArray[n2] = boxArray[0];
                for (int i = 1; i < n2; ++i) {
                    boxArray[i] = i % 2 == 0 ? box3 : box;
                }
                break;
            }
            case 4: {
                Box box;
                Box box4 = MatrixAtom.f.createBox(teXEnvironment);
                if (f2 != Float.POSITIVE_INFINITY) {
                    float f5 = Math.max((f2 - f - (float)(n2 / 2) * box4.getWidth()) / (float)Math.floor((n2 - 1) / 2), 0.0f);
                    box = new StrutBox(f5, 0.0f, 0.0f, 0.0f);
                } else {
                    box = a.createBox(teXEnvironment);
                }
                boxArray[0] = a;
                boxArray[n2] = boxArray[0];
                for (int i = 1; i < n2; ++i) {
                    boxArray[i] = i % 2 == 0 ? box : box4;
                }
                break;
            }
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            boxArray[0] = a;
            boxArray[n2] = boxArray[0];
        }
        return boxArray;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        int n;
        int n2;
        int n3 = this.a.b;
        int n4 = this.a.a;
        Box[][] boxArray = new Box[n3][n4];
        float[] fArray = new float[n3];
        float[] fArray2 = new float[n3];
        float[] fArray3 = new float[n4];
        float f = 0.0f;
        float f2 = teXEnvironment.getTeXFont().getDefaultRuleThickness(teXEnvironment.getStyle());
        if (this.d == 5) {
            teXEnvironment = teXEnvironment.copy();
            teXEnvironment.setStyle(4);
        }
        ArrayList<MulticolumnAtom> arrayList = new ArrayList<MulticolumnAtom>();
        for (n2 = 0; n2 < n3; ++n2) {
            fArray[n2] = 0.0f;
            fArray2[n2] = 0.0f;
            for (int i = 0; i < n4; ++i) {
                Atom atom = null;
                try {
                    atom = (Atom)((LinkedList)this.a.a.get(n2)).get(i);
                }
                catch (Exception exception) {
                    boxArray[n2][i - 1].a = 11;
                    i = n4 - 1;
                }
                boxArray[n2][i] = atom == null ? a : atom.createBox(teXEnvironment);
                fArray[n2] = Math.max(boxArray[n2][i].getDepth(), fArray[n2]);
                fArray2[n2] = Math.max(boxArray[n2][i].getHeight(), fArray2[n2]);
                if (boxArray[n2][i].a != 12) {
                    fArray3[i] = Math.max(boxArray[n2][i].getWidth(), fArray3[i]);
                    continue;
                }
                ((MulticolumnAtom)atom).setRowColumn(n2, i);
                arrayList.add((MulticolumnAtom)atom);
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            MulticolumnAtom multicolumnAtom = (MulticolumnAtom)arrayList.get(n2);
            int n5 = multicolumnAtom.getCol();
            int n6 = multicolumnAtom.getRow();
            int n7 = multicolumnAtom.getSkipped();
            float f3 = 0.0f;
            for (int i = n5; i < n5 + n7; ++i) {
                f3 += fArray3[i];
            }
            if (!(boxArray[n6][n5].getWidth() > f3)) continue;
            float f4 = (boxArray[n6][n5].getWidth() - f3) / (float)n7;
            n = n5;
            while (n < n5 + n7) {
                int n8 = n++;
                fArray3[n8] = fArray3[n8] + f4;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            f += fArray3[n2];
        }
        Box[] boxArray2 = this.getColumnSep(teXEnvironment, f);
        for (int i = 0; i < n4 + 1; ++i) {
            f += boxArray2[i].getWidth();
            if (this.a.get(i) == null) continue;
            f += ((VlineAtom)this.a.get(i)).getWidth(teXEnvironment);
        }
        VerticalBox verticalBox = new VerticalBox();
        Box box = c.createBox(teXEnvironment);
        verticalBox.add(d.createBox(teXEnvironment));
        float f5 = box.getHeight();
        float f6 = 0.0f;
        for (int i = 0; i < n3; ++i) {
            HorizontalBox horizontalBox = new HorizontalBox();
            block15: for (n = 0; n < n4; ++n) {
                switch (boxArray[i][n].a) {
                    case -1: 
                    case 12: {
                        Object object;
                        Object object2;
                        if (n == 0) {
                            if (this.a.get(0) != null) {
                                VlineAtom vlineAtom = (VlineAtom)this.a.get(0);
                                vlineAtom.setHeight(fArray2[i] + fArray[i] + box.getHeight());
                                vlineAtom.setShift(fArray[i] + box.getHeight() / 2.0f);
                                object2 = vlineAtom.createBox(teXEnvironment);
                                horizontalBox.add(new HorizontalBox((Box)object2, boxArray2[0].getWidth() + ((Box)object2).getWidth(), 0));
                            } else {
                                horizontalBox.add(boxArray2[0]);
                            }
                        }
                        boolean bl = true;
                        if (boxArray[i][n].a == -1) {
                            horizontalBox.add(new HorizontalBox(boxArray[i][n], fArray3[n], this.a[n]));
                        } else {
                            object2 = this.generateMulticolumn(teXEnvironment, boxArray2, fArray3, i, n);
                            object = (MulticolumnAtom)((LinkedList)this.a.a.get(i)).get(n);
                            n += ((MulticolumnAtom)object).getSkipped() - 1;
                            horizontalBox.add((Box)object2);
                            bl = ((MulticolumnAtom)object).hasRightVline();
                        }
                        if (bl && this.a.get(n + 1) != null) {
                            object2 = (VlineAtom)this.a.get(n + 1);
                            ((VlineAtom)object2).setHeight(fArray2[i] + fArray[i] + box.getHeight());
                            ((VlineAtom)object2).setShift(fArray[i] + box.getHeight() / 2.0f);
                            object = ((VlineAtom)object2).createBox(teXEnvironment);
                            if (n < n4 - 1) {
                                horizontalBox.add(new HorizontalBox((Box)object, boxArray2[n + 1].getWidth() + ((Box)object).getWidth(), 2));
                                continue block15;
                            }
                            horizontalBox.add(new HorizontalBox((Box)object, boxArray2[n + 1].getWidth() + ((Box)object).getWidth(), 1));
                            continue block15;
                        }
                        horizontalBox.add(boxArray2[n + 1]);
                        continue block15;
                    }
                    case 11: {
                        float f7 = teXEnvironment.getTextwidth();
                        f7 = f7 == Float.POSITIVE_INFINITY ? fArray3[n] : f7;
                        horizontalBox = new HorizontalBox(boxArray[i][n], f7, 0);
                        n = n4 - 1;
                        continue block15;
                    }
                    case 13: {
                        Object object = (HlineAtom)((LinkedList)this.a.a.get(i)).get(n);
                        ((HlineAtom)object).setWidth(f);
                        if (i >= 1 && ((LinkedList)this.a.a.get(i - 1)).get(n) instanceof HlineAtom) {
                            horizontalBox.add(new StrutBox(0.0f, 2.0f * f2, 0.0f, 0.0f));
                            ((HlineAtom)object).setShift(-box.getHeight() / 2.0f + f2);
                        } else {
                            ((HlineAtom)object).setShift(-box.getHeight() / 2.0f);
                        }
                        horizontalBox.add(((HlineAtom)object).createBox(teXEnvironment));
                        n = n4;
                    }
                }
            }
            if (boxArray[i][0].a != 13) {
                horizontalBox.setHeight(fArray2[i]);
                horizontalBox.setDepth(fArray[i]);
                verticalBox.add(horizontalBox);
                if (i >= n3 - 1) continue;
                verticalBox.add(box);
                continue;
            }
            verticalBox.add(horizontalBox);
        }
        verticalBox.add(e.createBox(teXEnvironment));
        f6 = verticalBox.getHeight() + verticalBox.getDepth();
        float f8 = teXEnvironment.getTeXFont().getAxisHeight(teXEnvironment.getStyle());
        verticalBox.setHeight(f6 / 2.0f + f8);
        verticalBox.setDepth(f6 / 2.0f - f8);
        return verticalBox;
    }

    private Box generateMulticolumn(TeXEnvironment teXEnvironment, Box[] boxArray, float[] fArray, int n, int n2) {
        int n3;
        float f = 0.0f;
        MulticolumnAtom multicolumnAtom = (MulticolumnAtom)((LinkedList)this.a.a.get(n)).get(n2);
        int n4 = multicolumnAtom.getSkipped();
        for (n3 = n2; n3 < n2 + n4 - 1; ++n3) {
            f += fArray[n3] + boxArray[n3 + 1].getWidth();
            if (this.a.get(n3 + 1) == null) continue;
            f += ((VlineAtom)this.a.get(n3 + 1)).getWidth(teXEnvironment);
        }
        f += fArray[n3];
        Box box = multicolumnAtom.createBox(teXEnvironment);
        float f2 = box.getWidth();
        if (f2 > f) {
            f = 0.0f;
        }
        multicolumnAtom.setWidth(f);
        box = multicolumnAtom.createBox(teXEnvironment);
        return box;
    }
}

