$(function () {

    var zindex = 10,
            dropped = 0,
            drop = function (event, ui) {
                if (ui.draggable.data('dropped') === 0) {
                    var x = $(this).data('value');
                    var y = ui.draggable.data('value');
                    var position = $(this).position();
                    dropped++;
                    ui.draggable.data('dropped', 1);
                    $(this).data('value', x - y);
                    ui.draggable
                            .css('left', position.left)
                            .css('top', position.top);
                    check();
                }
            },
            out = function (event, ui) {
                if (ui.draggable.data('dropped') === 1) {
                    var x = $(this).data('value');
                    var y = ui.draggable.data('value');
                    dropped--;
                    ui.draggable.data('dropped', 0);
                    $(this).data('value', x + y);
                    check();
                }
            };

    function check() {
        var bad = 0;

        for (var i = 1; i <= 7; i++) {
            bad += ($('#dropp' + i).data('value') === 0) ? 0 : 1;
        }

        if (bad === 0) {
            $('#jplayer_well').jPlayer('play');
            $('.dragganddropp').fadeOut(800);
            $('.end').fadeIn(800);
        } else {
            if (dropped === 7) {
                $('#jplayer_wrong').jPlayer('play');
            }
        }
    }
    $(".letterinput").keyup(function () {
        var no = $(this).attr('id');
        var str = $(this).val().toLowerCase().trim();
        var maxlength = parseInt($(this).attr('maxlength'));
        if (str === $(this).data('value').toString()) {
            $('#dragg' + no.replace('i', '') + ' span:nth-child(1)').text(str);
            $(this).remove();
            $('#dragg' + no.replace('i', '') + ' span:nth-child(2)').fadeIn(400);
        } else if (str.length === maxlength) {
            $('#jplayer_wrong').jPlayer('play');
        }
    });
    $(".dragg").draggable({
        start: function () {
            zindex++;
            $(this).css('z-index', zindex);
        }
    });

    $('.dropp').droppable({
        accept: ".dragg",
        tolerance: "pointer",
        drop: drop,
        out: out
    });

});