$(function() {

    var zindex = 10,
            dropped = 0,
            drop = function(event, ui) {
                var position = $(this).position();
                ui.draggable
                        .css('left', position.left + 100)
                        .css('top', position.top + 3);
                
                if (ui.draggable.data('dropped') === 0) {
                    var x = $(this).data('value');
                    var y = ui.draggable.data('value');

                    dropped++;
                    ui.draggable.data('dropped', 1);
                    $(this).data('value', x - y);
                    check();
                }
            },
            out = function(event, ui) {
                if (ui.draggable.data('dropped') === 1) {
                    var x = $(this).data('value');
                    var y = ui.draggable.data('value');
                    dropped--;
                    ui.draggable.data('dropped', 0);
                    $(this).data('value', x + y);
                    check();
                }
            };

    function check() {
        var bad = 0;

        for (var i = 1; i <= 4; i++) {
            bad += ($('#dropp' + i).data('value') === 0) ? 0 : 1;
        }

        if (bad === 0) {
            $('#jplayer_well').jPlayer('play');
        } else {
            if (dropped === 4) {
                $('#jplayer_wrong').jPlayer('play');
            }
        }
    }

    $(".dragg").draggable({
        start: function() {
            zindex++;
            $(this).css('z-index', zindex);
        }
    });

    $('.dropp').droppable({
        accept: ".dragg",
        tolerance: "pointer",
        drop: drop,
        out: out
    });

});